/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Variant;

@Beta
@NonNullByDefault
@ThreadSafe
public abstract class CanonicalValueViolation
implements Serializable {
    private static final CanonicalValueViolation EMPTY = new Regular(null, null);
    private static final Variant<?, CanonicalValueViolation> EMPTY_VARIANT = Variant.ofSecond(EMPTY);
    private static final long serialVersionUID = 1L;

    public static CanonicalValueViolation empty() {
        return EMPTY;
    }

    public static CanonicalValueViolation of(Exception cause) {
        return new WithException(cause);
    }

    public static CanonicalValueViolation of(@Nullable String appTag, @Nullable String message) {
        return appTag == null && message == null ? EMPTY : new Regular(appTag, message);
    }

    public static <T> Variant<T, CanonicalValueViolation> emptyVariant() {
        return EMPTY_VARIANT;
    }

    public static <T> Variant<T, CanonicalValueViolation> variantOf(Exception cause) {
        return Variant.ofSecond(CanonicalValueViolation.of(cause));
    }

    public static <T> Variant<T, CanonicalValueViolation> variantOf(String message) {
        return CanonicalValueViolation.variantOf(null, message);
    }

    public static <T> Variant<T, CanonicalValueViolation> variantOf(@Nullable String appTag, String message) {
        return Variant.ofSecond(CanonicalValueViolation.of(appTag, message));
    }

    public final Optional<String> getAppTag() {
        return CanonicalValueViolation.nullableString(this.appTag());
    }

    public final Optional<String> getMessage() {
        return CanonicalValueViolation.nullableString(this.appTag());
    }

    abstract @Nullable String appTag();

    abstract @Nullable String message();

    public final int hashCode() {
        return Objects.hash(this.appTag(), this.message());
    }

    public final boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CanonicalValueViolation)) {
            return false;
        }
        CanonicalValueViolation other = (CanonicalValueViolation)obj;
        return Objects.equals(this.appTag(), other.appTag()) && Objects.equals(this.message(), other.message());
    }

    public final String toString() {
        return this.addToString(MoreObjects.toStringHelper(this)).toString();
    }

    abstract MoreObjects.ToStringHelper addToString(MoreObjects.ToStringHelper var1);

    private static Optional<String> nullableString(@Nullable String str) {
        return str != null ? Optional.of(str) : Optional.empty();
    }

    @SuppressFBWarnings(value={"NM_CLASS_NOT_EXCEPTION"})
    public static class WithException
    extends CanonicalValueViolation {
        private static final long serialVersionUID = 1L;
        private final Exception cause;

        WithException(Exception cause) {
            this.cause = Objects.requireNonNull(cause);
        }

        @Override
        @SuppressFBWarnings(value={"NP_NONNULL_RETURN_VIOLATION"})
        @Nullable String appTag() {
            return null;
        }

        @Override
        @Nullable String message() {
            return this.cause.getMessage();
        }

        public final Exception getCause() {
            return this.cause;
        }

        @Override
        MoreObjects.ToStringHelper addToString(MoreObjects.ToStringHelper helper) {
            return helper.add("cause", this.cause);
        }
    }

    public static class Regular
    extends CanonicalValueViolation {
        private static final long serialVersionUID = 1L;
        private final @Nullable String appTag;
        private final @Nullable String message;

        Regular(@Nullable String appTag, @Nullable String message) {
            this.appTag = appTag;
            this.message = message;
        }

        @Override
        @Nullable String appTag() {
            return this.appTag;
        }

        @Override
        @Nullable String message() {
            return this.message;
        }

        @Override
        MoreObjects.ToStringHelper addToString(MoreObjects.ToStringHelper helper) {
            return helper.omitNullValues().add("app-tag", this.appTag).add("message", this.message);
        }
    }
}

