/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import java.math.BigDecimal;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Variant;
import org.opendaylight.yangtools.yang.common.AbstractCanonicalValueSupport;
import org.opendaylight.yangtools.yang.common.CanonicalValue;
import org.opendaylight.yangtools.yang.common.CanonicalValueSupport;
import org.opendaylight.yangtools.yang.common.CanonicalValueViolation;

@Beta
@NonNullByDefault
public class Decimal64
extends Number
implements CanonicalValue<Decimal64> {
    private static final CanonicalValueSupport<Decimal64> SUPPORT = new Support();
    private static final long serialVersionUID = 1L;
    private static final int MAX_FRACTION_DIGITS = 18;
    private static final long[] SCALE = new long[]{10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private final byte scaleOffset;
    private final long value;

    @VisibleForTesting
    Decimal64(int fractionDigits, long intPart, long fracPart, boolean negative) {
        Preconditions.checkArgument(fractionDigits >= 1 && fractionDigits <= 18);
        this.scaleOffset = (byte)(fractionDigits - 1);
        long bits = intPart * SCALE[this.scaleOffset] + fracPart;
        this.value = negative ? -bits : bits;
    }

    protected Decimal64(Decimal64 other) {
        this.scaleOffset = other.scaleOffset;
        this.value = other.value;
    }

    public static Decimal64 valueOf(byte byteVal) {
        return byteVal < 0 ? new Decimal64(1, -byteVal, 0L, true) : new Decimal64(1, byteVal, 0L, false);
    }

    public static Decimal64 valueOf(short shortVal) {
        return shortVal < 0 ? new Decimal64(1, -shortVal, 0L, true) : new Decimal64(1, shortVal, 0L, false);
    }

    public static Decimal64 valueOf(int intVal) {
        return intVal < 0 ? new Decimal64(1, -((long)intVal), 0L, true) : new Decimal64(1, intVal, 0L, false);
    }

    public static Decimal64 valueOf(long longVal) {
        return Decimal64.valueOf(Long.toString(longVal));
    }

    public static Decimal64 valueOf(double doubleVal) {
        return Decimal64.valueOf(Double.toString(doubleVal));
    }

    public static Decimal64 valueOf(BigDecimal decimalVal) {
        return Decimal64.valueOf(decimalVal.toPlainString());
    }

    public static Decimal64 valueOf(String str) {
        Variant<Decimal64, CanonicalValueViolation> variant = SUPPORT.fromString(str);
        Optional<Decimal64> value = variant.tryFirst();
        if (value.isPresent()) {
            return value.get();
        }
        Optional<String> message = variant.getSecond().getMessage();
        throw message.isPresent() ? new NumberFormatException(message.get()) : new NumberFormatException();
    }

    public final BigDecimal decimalValue() {
        return BigDecimal.valueOf(this.value, this.scaleOffset + 1);
    }

    @Override
    public final int intValue() {
        return (int)this.intPart();
    }

    @Override
    public final long longValue() {
        return this.intPart();
    }

    @Override
    public final float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public final double doubleValue() {
        return 1.0 * (double)this.value / (double)SCALE[this.scaleOffset];
    }

    public final byte byteValueExact() {
        byte ret;
        long val = this.longValueExact();
        if (val != (long)(ret = (byte)val)) {
            throw new ArithmeticException("Value " + val + " is outside of byte range");
        }
        return ret;
    }

    public final short shortValueExact() {
        short ret;
        long val = this.longValueExact();
        if (val != (long)(ret = (short)val)) {
            throw new ArithmeticException("Value " + val + " is outside of short range");
        }
        return ret;
    }

    public final int intValueExact() {
        int ret;
        long val = this.longValueExact();
        if (val != (long)(ret = (int)val)) {
            throw new ArithmeticException("Value " + val + " is outside of integer range");
        }
        return ret;
    }

    public final long longValueExact() {
        if (this.fracPart() != 0L) {
            throw new ArithmeticException("Conversion of " + this + " would lose fraction");
        }
        return this.intPart();
    }

    @Override
    public final int compareTo(Decimal64 o) {
        if (this == o) {
            return 0;
        }
        if (this.scaleOffset == o.scaleOffset) {
            return Long.compare(this.value, o.value);
        }
        return Double.compare(this.doubleValue(), o.doubleValue());
    }

    @Override
    public final String toCanonicalString() {
        StringBuilder sb = new StringBuilder(21).append(this.intPart()).append('.');
        long fracPart = this.fracPart();
        if (fracPart != 0L) {
            sb.append(Strings.padStart(Long.toString(fracPart), this.scaleOffset + 1, '0'));
        } else {
            sb.append('0');
        }
        return sb.toString();
    }

    @Override
    public final CanonicalValueSupport<Decimal64> support() {
        return SUPPORT;
    }

    public final int hashCode() {
        return Long.hashCode(this.intPart()) * 31 + Long.hashCode(this.fracPart());
    }

    public final boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Decimal64)) {
            return false;
        }
        Decimal64 other = (Decimal64)obj;
        if (this.scaleOffset == other.scaleOffset) {
            return this.value == other.value;
        }
        return this.intPart() == other.intPart() && this.fracPart() == other.fracPart();
    }

    public final String toString() {
        return this.toCanonicalString();
    }

    private long intPart() {
        return this.value / SCALE[this.scaleOffset];
    }

    private long fracPart() {
        return Math.abs(this.value % SCALE[this.scaleOffset]);
    }

    private static int toInt(char ch, int index) {
        if (ch < '0' || ch > '9') {
            throw new NumberFormatException("Illegal character at offset " + index);
        }
        return ch - 48;
    }

    static {
        Verify.verify(SCALE.length == 18);
    }

    public static final class Support
    extends AbstractCanonicalValueSupport<Decimal64> {
        public Support() {
            super(Decimal64.class);
        }

        @Override
        public Variant<Decimal64, CanonicalValueViolation> fromString(String str) {
            char ch;
            char ch2;
            int idx;
            boolean negative;
            if (str.isEmpty()) {
                return CanonicalValueViolation.variantOf("Empty string is not a valid decimal64 representation");
            }
            switch (str.charAt(0)) {
                case '-': {
                    negative = true;
                    idx = 1;
                    break;
                }
                case '+': {
                    negative = false;
                    idx = 1;
                    break;
                }
                default: {
                    negative = false;
                    idx = 0;
                }
            }
            if (idx == str.length()) {
                return CanonicalValueViolation.variantOf("Missing digits after sign");
            }
            int limit = str.length() - 1;
            while (idx < limit && str.charAt(idx) == '0' && (ch2 = str.charAt(idx + 1)) >= '0' && ch2 <= '9') {
                ++idx;
            }
            int intLen = 0;
            long intPart = 0L;
            while (idx <= limit && (ch = str.charAt(idx)) != '.') {
                if (intLen == 18) {
                    return CanonicalValueViolation.variantOf("Integer part is longer than 18 digits");
                }
                intPart = 10L * intPart + (long)Decimal64.toInt(ch, idx);
                ++idx;
                ++intLen;
            }
            if (idx > limit) {
                return Variant.ofFirst(new Decimal64(1, intPart, 0L, negative));
            }
            if (++idx > limit) {
                return CanonicalValueViolation.variantOf("Value '" + str + "' is missing fraction digits");
            }
            while (idx < limit && str.charAt(limit) == '0') {
                --limit;
            }
            int fracLimit = 18 - intLen;
            int fracLen = 0;
            long fracPart = 0L;
            while (idx <= limit) {
                char ch3 = str.charAt(idx);
                if (fracLen == fracLimit) {
                    return CanonicalValueViolation.variantOf("Fraction part longer than " + fracLimit + " digits");
                }
                fracPart = 10L * fracPart + (long)Decimal64.toInt(ch3, idx);
                ++idx;
                fracLen = (byte)(fracLen + 1);
            }
            return Variant.ofFirst(new Decimal64(fracLen, intPart, fracPart, negative));
        }
    }
}

