/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.QQNv1;
import org.opendaylight.yangtools.yang.common.YangNamespaceContext;

@Beta
@NonNullByDefault
public final class QualifiedQName
extends AbstractQName
implements Comparable<QualifiedQName> {
    private static final long serialVersionUID = 1L;
    private static final Interner<QualifiedQName> INTERNER = Interners.newWeakInterner();
    private final String prefix;

    private QualifiedQName(String prefix, String localName) {
        super(localName);
        this.prefix = Objects.requireNonNull(prefix);
    }

    public static QualifiedQName of(String prefix, String localName) {
        return new QualifiedQName(QualifiedQName.checkLocalName(prefix), QualifiedQName.checkLocalName(localName));
    }

    public static QualifiedQName readFrom(DataInput in) throws IOException {
        return QualifiedQName.of(in.readUTF(), in.readUTF());
    }

    public Optional<QName> bindTo(YangNamespaceContext namespaceContext) {
        return namespaceContext.findNamespaceForPrefix(this.prefix).map(this::bindTo);
    }

    private QName bindTo(QNameModule namespace) {
        return new QName(namespace, this.getLocalName());
    }

    @Override
    @SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="Interning identity check")
    public QualifiedQName intern() {
        String name = this.getLocalName();
        String internedName = name.intern();
        QualifiedQName template = internedName == name ? this : new QualifiedQName(this.prefix.intern(), internedName);
        return INTERNER.intern(template);
    }

    @Override
    public int compareTo(QualifiedQName o) {
        return this.getLocalName().compareTo(o.getLocalName());
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        out.writeUTF(this.getLocalName());
    }

    @Override
    public int hashCode() {
        return this.getLocalName().hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof QualifiedQName && this.getLocalName().equals(((AbstractQName)obj).getLocalName());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("localName", this.getLocalName()).toString();
    }

    @Override
    Object writeReplace() {
        return new QQNv1(this);
    }
}

