/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilderCompat;

public final class RpcResultBuilder<T>
extends RpcResultBuilderCompat<T>
implements Builder<RpcResult<T>> {
    private ImmutableList.Builder<RpcError> errors;
    private T result;
    private final boolean successful;

    private RpcResultBuilder(boolean successful, T result) {
        this.successful = successful;
        this.result = result;
    }

    public static <T> @NonNull RpcResultBuilder<T> success() {
        return new RpcResultBuilder<Object>(true, null);
    }

    public static <T> @NonNull RpcResultBuilder<T> success(T result) {
        return new RpcResultBuilder<T>(true, result);
    }

    public static <T> @NonNull RpcResultBuilder<T> success(Builder<T> builder) {
        return RpcResultBuilder.success(builder.build());
    }

    public static <T> @NonNull RpcResultBuilder<T> failed() {
        return new RpcResultBuilder<Object>(false, null);
    }

    public static <T> @NonNull RpcResultBuilder<T> status(boolean success) {
        return new RpcResultBuilder<Object>(success, null);
    }

    public static <T> @NonNull RpcResultBuilder<T> from(RpcResult<T> other) {
        return new RpcResultBuilder<T>(other.isSuccessful(), other.getResult()).withRpcErrors(other.getErrors());
    }

    public static @NonNull RpcError newError(RpcError.ErrorType errorType, String tag, String message) {
        return new RpcErrorImpl(RpcError.ErrorSeverity.ERROR, errorType, tag != null ? tag : "operation-failed", message, null, null, null);
    }

    public static @NonNull RpcError newError(RpcError.ErrorType errorType, String tag, String message, String applicationTag, String info, Throwable cause) {
        return new RpcErrorImpl(RpcError.ErrorSeverity.ERROR, errorType, tag != null ? tag : "operation-failed", message, applicationTag, info, cause);
    }

    public static @NonNull RpcError newWarning(RpcError.ErrorType errorType, String tag, String message) {
        return new RpcErrorImpl(RpcError.ErrorSeverity.WARNING, errorType, tag, message, null, null, null);
    }

    public static @NonNull RpcError newWarning(RpcError.ErrorType errorType, String tag, String message, String applicationTag, String info, Throwable cause) {
        return new RpcErrorImpl(RpcError.ErrorSeverity.WARNING, errorType, tag, message, applicationTag, info, cause);
    }

    public @NonNull RpcResultBuilder<T> withResult(T result) {
        this.result = result;
        return this;
    }

    public @NonNull RpcResultBuilder<T> withResult(Builder<T> builder) {
        return this.withResult(builder.build());
    }

    private void addError(RpcError.ErrorSeverity severity, RpcError.ErrorType errorType, String tag, String message, String applicationTag, String info, Throwable cause) {
        this.addError(new RpcErrorImpl(severity, errorType, tag != null ? tag : "operation-failed", message, applicationTag, info, cause));
    }

    private void addError(RpcError error) {
        if (this.errors == null) {
            this.errors = new ImmutableList.Builder();
        }
        this.errors.add((Object)error);
    }

    public @NonNull RpcResultBuilder<T> withWarning(RpcError.ErrorType errorType, String tag, String message) {
        this.addError(RpcError.ErrorSeverity.WARNING, errorType, tag, message, null, null, null);
        return this;
    }

    public @NonNull RpcResultBuilder<T> withWarning(RpcError.ErrorType errorType, String tag, String message, String applicationTag, String info, Throwable cause) {
        this.addError(RpcError.ErrorSeverity.WARNING, errorType, tag, message, applicationTag, info, cause);
        return this;
    }

    public @NonNull RpcResultBuilder<T> withError(RpcError.ErrorType errorType, String message) {
        this.addError(RpcError.ErrorSeverity.ERROR, errorType, null, message, null, null, null);
        return this;
    }

    public @NonNull RpcResultBuilder<T> withError(RpcError.ErrorType errorType, String tag, String message) {
        this.addError(RpcError.ErrorSeverity.ERROR, errorType, tag, message, null, null, null);
        return this;
    }

    public @NonNull RpcResultBuilder<T> withError(RpcError.ErrorType errorType, String message, Throwable cause) {
        this.addError(RpcError.ErrorSeverity.ERROR, errorType, null, message, null, null, cause);
        return this;
    }

    public @NonNull RpcResultBuilder<T> withError(RpcError.ErrorType errorType, String tag, String message, String applicationTag, String info, Throwable cause) {
        this.addError(RpcError.ErrorSeverity.ERROR, errorType, tag, message, applicationTag, info, cause);
        return this;
    }

    public @NonNull RpcResultBuilder<T> withRpcError(RpcError error) {
        this.addError(error);
        return this;
    }

    public RpcResultBuilder<T> withRpcErrors(Collection<? extends RpcError> rpcErrors) {
        if (rpcErrors != null) {
            for (RpcError rpcError : rpcErrors) {
                this.addError(rpcError);
            }
        }
        return this;
    }

    @Override
    public RpcResult<T> build() {
        return new RpcResultImpl<T>(this.successful, this.result, (ImmutableList<RpcError>)(this.errors != null ? this.errors.build() : ImmutableList.of()));
    }

    @Override
    public @NonNull FluentFuture<RpcResult<T>> buildFuture() {
        return FluentFuture.from(Futures.immediateFuture(this.build()));
    }

    private static class RpcErrorImpl
    implements RpcError,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String applicationTag;
        private final String tag;
        private final String info;
        private final RpcError.ErrorSeverity severity;
        private final String message;
        private final RpcError.ErrorType errorType;
        private final Throwable cause;

        RpcErrorImpl(RpcError.ErrorSeverity severity, RpcError.ErrorType errorType, String tag, String message, String applicationTag, String info, Throwable cause) {
            this.severity = severity;
            this.errorType = errorType;
            this.tag = tag;
            this.message = message;
            this.applicationTag = applicationTag;
            this.info = info;
            this.cause = cause;
        }

        @Override
        public String getApplicationTag() {
            return this.applicationTag;
        }

        @Override
        public String getTag() {
            return this.tag;
        }

        @Override
        public String getInfo() {
            return this.info;
        }

        @Override
        public RpcError.ErrorSeverity getSeverity() {
            return this.severity;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public RpcError.ErrorType getErrorType() {
            return this.errorType;
        }

        @Override
        public Throwable getCause() {
            return this.cause;
        }

        public String toString() {
            return "RpcError [message=" + this.message + ", severity=" + (Object)((Object)this.severity) + ", errorType=" + (Object)((Object)this.errorType) + ", tag=" + this.tag + ", applicationTag=" + this.applicationTag + ", info=" + this.info + ", cause=" + this.cause + "]";
        }
    }

    private static class RpcResultImpl<T>
    implements RpcResult<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final ImmutableList<RpcError> errors;
        private final T result;
        private final boolean successful;

        RpcResultImpl(boolean successful, T result, ImmutableList<RpcError> errors) {
            this.successful = successful;
            this.result = result;
            this.errors = Objects.requireNonNull(errors);
        }

        public ImmutableList<RpcError> getErrors() {
            return this.errors;
        }

        @Override
        public T getResult() {
            return this.result;
        }

        @Override
        public boolean isSuccessful() {
            return this.successful;
        }

        public String toString() {
            return "RpcResult [successful=" + this.successful + ", result=" + this.result + ", errors=" + this.errors + "]";
        }
    }
}

