/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Variant;
import org.opendaylight.yangtools.yang.common.AbstractCanonicalValueSupport;
import org.opendaylight.yangtools.yang.common.CanonicalValue;
import org.opendaylight.yangtools.yang.common.CanonicalValueSupport;
import org.opendaylight.yangtools.yang.common.CanonicalValueViolation;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;

@Beta
@NonNullByDefault
public class Uint16
extends Number
implements CanonicalValue<Uint16> {
    private static final CanonicalValueSupport<Uint16> SUPPORT = new Support();
    private static final long serialVersionUID = 1L;
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 65535;
    private static final Uint16[] CACHE = new Uint16[255];
    private static final Uint16[] COMMON = new Uint16[]{new Uint16(Short.MAX_VALUE), new Uint16(Short.MIN_VALUE), new Uint16(-1)};
    private static final int DEFAULT_LRU_SIZE = 1024;
    private static final String LRU_SIZE_PROPERTY = "org.opendaylight.yangtools.yang.common.Uint16.LRU.size";
    private static final int MAX_LRU_SIZE = 65536;
    private static final int LRU_SIZE;
    private static final LoadingCache<Short, Uint16> LRU;
    private final short value;

    Uint16(short value) {
        this.value = value;
    }

    protected Uint16(Uint16 other) {
        this.value = other.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Uint16 instanceFor(short value) {
        int slot = Short.toUnsignedInt(value);
        if (slot >= CACHE.length) {
            for (Uint16 c : COMMON) {
                if (c.value != value) continue;
                return c;
            }
            return LRU.getUnchecked(value);
        }
        Uint16 ret = CACHE[slot];
        if (ret != null) return ret;
        Uint16[] uint16Array = CACHE;
        synchronized (CACHE) {
            ret = CACHE[slot];
            if (ret != null) return ret;
            Uint16.CACHE[slot] = ret = new Uint16(value);
            // ** MonitorExit[var3_5] (shouldn't be in output)
            return ret;
        }
    }

    public static Uint16 fromShortBits(short bits) {
        return Uint16.instanceFor(bits);
    }

    public static Uint16 valueOf(byte byteVal) {
        Preconditions.checkArgument(byteVal >= 0, "Negative values are not allowed");
        return Uint16.instanceFor(byteVal);
    }

    public static Uint16 valueOf(short shortVal) {
        Preconditions.checkArgument(shortVal >= 0, "Negative values are not allowed");
        return Uint16.instanceFor(shortVal);
    }

    public static Uint16 valueOf(int intVal) {
        Preconditions.checkArgument(intVal >= 0 && intVal <= 65535, "Value %s is outside of allowed range", intVal);
        return Uint16.instanceFor((short)(intVal & 0xFFFF));
    }

    public static Uint16 valueOf(long longVal) {
        Preconditions.checkArgument(longVal >= 0L && longVal <= 65535L, "Value %s is outside of allowed range", longVal);
        return Uint16.instanceFor((short)(longVal & 0xFFFFL));
    }

    public static Uint16 valueOf(Uint8 uint) {
        return Uint16.instanceFor(uint.shortValue());
    }

    public static Uint16 valueOf(Uint32 uint) {
        return Uint16.valueOf(uint.longValue());
    }

    public static Uint16 valueOf(Uint64 uint) {
        return Uint16.valueOf(uint.longValue());
    }

    public static Uint16 valueOf(String string) {
        return Uint16.valueOf(string, 10);
    }

    public static Uint16 valueOf(String string, int radix) {
        return Uint16.valueOf(Integer.parseInt(string, radix));
    }

    @Override
    public final short shortValue() {
        return this.value;
    }

    @Override
    public final int intValue() {
        return Short.toUnsignedInt(this.value);
    }

    @Override
    public final long longValue() {
        return Short.toUnsignedLong(this.value);
    }

    @Override
    public final float floatValue() {
        return this.intValue();
    }

    @Override
    public final double doubleValue() {
        return this.intValue();
    }

    @Override
    public final int compareTo(Uint16 o) {
        return Integer.compare(this.intValue(), o.intValue());
    }

    @Override
    public final String toCanonicalString() {
        return String.valueOf(this.intValue());
    }

    @Override
    public final CanonicalValueSupport<Uint16> support() {
        return SUPPORT;
    }

    public final int hashCode() {
        return Short.hashCode(this.value);
    }

    public final boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof Uint16 && this.value == ((Uint16)obj).value;
    }

    public final String toString() {
        return this.toCanonicalString();
    }

    private Object readResolve() {
        return Uint16.instanceFor(this.value);
    }

    static {
        int p = Integer.getInteger(LRU_SIZE_PROPERTY, 1024);
        LRU_SIZE = p >= 0 ? Math.min(p, 65536) : 1024;
        LRU = CacheBuilder.newBuilder().weakValues().maximumSize(LRU_SIZE).build(new CacheLoader<Short, Uint16>(){

            @Override
            public Uint16 load(Short key) {
                return new Uint16(key);
            }
        });
    }

    public static final class Support
    extends AbstractCanonicalValueSupport<Uint16> {
        public Support() {
            super(Uint16.class);
        }

        @Override
        public Variant<Uint16, CanonicalValueViolation> fromString(String str) {
            try {
                return Variant.ofFirst(Uint16.valueOf(str));
            }
            catch (IllegalArgumentException e) {
                return CanonicalValueViolation.variantOf(e);
            }
        }
    }
}

