/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.stream;

import com.google.common.annotations.Beta;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayDeque;
import java.util.Deque;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class LoggingNormalizedNodeStreamWriter
implements NormalizedNodeStreamWriter {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingNormalizedNodeStreamWriter.class);
    private static final int DEFAULT_INDENT_SIZE = 2;
    private final Deque<String> indent = new ArrayDeque<String>();
    private final String indentStr;

    public LoggingNormalizedNodeStreamWriter() {
        this(2);
    }

    public LoggingNormalizedNodeStreamWriter(int indentSize) {
        this.indentStr = Strings.repeat(" ", indentSize);
        this.indent.push("");
    }

    private String ind() {
        return this.indent.peek();
    }

    private void decIndent() {
        this.indent.pop();
    }

    private void incIndent() {
        this.indent.push(this.ind() + this.indentStr);
    }

    @Override
    public void startUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        LOG.debug("{}{}[](no key)", (Object)this.ind(), (Object)name);
        this.incIndent();
    }

    @Override
    public void startUnkeyedList(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        LOG.debug("{}{}(no key)", (Object)this.ind(), (Object)name);
        this.incIndent();
    }

    @Override
    public void startOrderedMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
    }

    @Override
    public void startMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        LOG.debug("{}{}(key)", (Object)this.ind(), (Object)name);
        this.incIndent();
    }

    @Override
    public void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, int childSizeHint) {
        LOG.debug("{}{}[](key)", (Object)this.ind(), (Object)identifier);
        this.incIndent();
    }

    @Override
    public void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        LOG.debug("{}{}(leaf-list)", (Object)this.ind(), (Object)name);
        this.incIndent();
    }

    @Override
    public void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        LOG.debug("{}{}(leaf-list)", (Object)this.ind(), (Object)name);
        this.incIndent();
    }

    @Override
    public void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        LOG.debug("{}{}(container)", (Object)this.ind(), (Object)name);
        this.incIndent();
    }

    @Override
    public void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        LOG.debug("{}{}(choice)", (Object)this.ind(), (Object)name);
        this.incIndent();
    }

    @Override
    public void startAugmentationNode(YangInstanceIdentifier.AugmentationIdentifier identifier) {
        LOG.debug("{}{}(augmentation)", (Object)this.ind(), (Object)identifier);
        this.incIndent();
    }

    @Override
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public void leafSetEntryNode(QName name, Object value) {
        LOG.debug("{}{}({}) ", this.ind(), value, value.getClass().getSimpleName());
    }

    @Override
    public void leafNode(YangInstanceIdentifier.NodeIdentifier name, Object value) {
        if (value == null) {
            LOG.debug("{}{}(leaf(null))=null", (Object)this.ind(), (Object)name);
        } else {
            LOG.debug("{}{}(leaf({}))={}", this.ind(), name, value.getClass().getSimpleName(), value);
        }
    }

    @Override
    public void endNode() {
        this.decIndent();
        LOG.debug("{}(end)", (Object)this.ind());
    }

    @Override
    public void anyxmlNode(YangInstanceIdentifier.NodeIdentifier name, Object value) {
        LOG.debug("{}{}(anyxml)={}", this.ind(), name, value);
    }

    @Override
    public void startYangModeledAnyXmlNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        LOG.debug("{}{}(yangModeledAnyXml)", (Object)this.ind(), (Object)name);
        this.incIndent();
    }

    @Override
    public void flush() {
        LOG.trace("<<FLUSH>>");
    }

    @Override
    public void close() {
        LOG.debug("<<END-OF-STREAM>>");
    }
}

