/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.tree.spi;

import com.google.common.base.Verify;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.util.MapAdaptor;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.AbstractContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.LazyContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.MaterializedContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.MutableTreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.SimpleContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.Version;

abstract class AbstractMutableContainerNode
implements MutableTreeNode {
    private final Version version;
    private Map<YangInstanceIdentifier.PathArgument, TreeNode> children;
    private NormalizedNode<?, ?> data;
    private Version subtreeVersion;

    protected AbstractMutableContainerNode(AbstractContainerNode parent, Map<YangInstanceIdentifier.PathArgument, TreeNode> children) {
        this.data = parent.getData();
        this.version = parent.getVersion();
        this.subtreeVersion = parent.getSubtreeVersion();
        this.children = Objects.requireNonNull(children);
    }

    protected final Version getVersion() {
        return this.version;
    }

    protected final TreeNode getModifiedChild(YangInstanceIdentifier.PathArgument child) {
        return this.children.get(child);
    }

    protected final NormalizedNodeContainer<?, YangInstanceIdentifier.PathArgument, NormalizedNode<?, ?>> getData() {
        return (NormalizedNodeContainer)this.data;
    }

    @Override
    public final void setSubtreeVersion(Version subtreeVersion) {
        this.subtreeVersion = Objects.requireNonNull(subtreeVersion);
    }

    @Override
    public final void addChild(TreeNode child) {
        this.children.put((YangInstanceIdentifier.PathArgument)child.getIdentifier(), child);
    }

    @Override
    public final void removeChild(YangInstanceIdentifier.PathArgument id) {
        this.children.remove(id);
    }

    @Override
    public final void setData(NormalizedNode<?, ?> data) {
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public final TreeNode seal() {
        AbstractContainerNode ret;
        if (!this.version.equals(this.subtreeVersion)) {
            Map<YangInstanceIdentifier.PathArgument, TreeNode> newChildren = MapAdaptor.getDefaultInstance().optimize(this.children);
            int dataSize = this.getData().getValue().size();
            if (dataSize != newChildren.size()) {
                Verify.verify(dataSize > newChildren.size(), "Detected %s modified children, data has only %s", newChildren.size(), dataSize);
                ret = new LazyContainerNode(this.data, this.version, newChildren, this.subtreeVersion);
            } else {
                ret = new MaterializedContainerNode(this.data, this.version, newChildren, this.subtreeVersion);
            }
        } else {
            ret = new SimpleContainerNode(this.data, this.version);
        }
        this.children = null;
        return ret;
    }
}

