/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.tree.spi;

import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.SimpleContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.ValueNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.Version;

public final class TreeNodeFactory {
    private TreeNodeFactory() {
        throw new UnsupportedOperationException("Utility class should not be instantiated");
    }

    public static TreeNode createTreeNode(NormalizedNode<?, ?> data, Version version) {
        if (data instanceof NormalizedNodeContainer) {
            NormalizedNodeContainer container = (NormalizedNodeContainer)data;
            return new SimpleContainerNode(container, version);
        }
        if (data instanceof OrderedNodeContainer) {
            OrderedNodeContainer container = (OrderedNodeContainer)data;
            return new SimpleContainerNode(container, version);
        }
        return new ValueNode(data, version);
    }
}

