/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.HelperMethods;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UsesNode;

public interface DataNodeContainer {
    public Set<TypeDefinition<?>> getTypeDefinitions();

    public Collection<DataSchemaNode> getChildNodes();

    public Set<GroupingDefinition> getGroupings();

    @Deprecated
    default public @Nullable DataSchemaNode getDataChildByName(QName name) {
        return this.findDataChildByName(name).orElse(null);
    }

    public Optional<DataSchemaNode> findDataChildByName(QName var1);

    public Set<UsesNode> getUses();

    @Beta
    default public Optional<DataSchemaNode> findDataTreeChild(QName name) {
        Optional<DataSchemaNode> optDataChild = this.findDataChildByName(name);
        if (HelperMethods.isDataNode(optDataChild)) {
            return optDataChild;
        }
        for (DataSchemaNode child : this.getChildNodes()) {
            if (!(child instanceof ChoiceSchemaNode)) continue;
            for (CaseSchemaNode choiceCase : ((ChoiceSchemaNode)child).getCases().values()) {
                Optional<DataSchemaNode> caseChild = choiceCase.findDataTreeChild(name);
                if (!caseChild.isPresent()) continue;
                return caseChild;
            }
        }
        return Optional.empty();
    }

    @Beta
    default public Optional<DataSchemaNode> findDataTreeChild(QName ... path) {
        return this.findDataTreeChild(Arrays.asList(path));
    }

    @Beta
    default public Optional<DataSchemaNode> findDataTreeChild(Iterable<QName> path) {
        Iterator<QName> it = path.iterator();
        DataNodeContainer parent = this;
        Optional<DataSchemaNode> optChild;
        while ((optChild = parent.findDataTreeChild(Objects.requireNonNull(it.next()))).isPresent() && it.hasNext()) {
            DataSchemaNode child = optChild.get();
            Preconditions.checkArgument(child instanceof DataNodeContainer, "Path %s extends beyond terminal child %s", path, (Object)child);
            parent = (DataNodeContainer)((Object)child);
        }
        return optChild;
    }
}

