/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;

public abstract class SchemaPath
implements Immutable {
    private static final AtomicReferenceFieldUpdater<SchemaPath, ImmutableList> LEGACYPATH_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SchemaPath.class, ImmutableList.class, "legacyPath");
    public static final @NonNull SchemaPath ROOT = new AbsoluteSchemaPath(null, null);
    public static final @NonNull SchemaPath SAME = new RelativeSchemaPath(null, null);
    private final SchemaPath parent;
    private final QName qname;
    private final int hash;
    private volatile ImmutableList<QName> legacyPath;

    SchemaPath(SchemaPath parent, QName qname) {
        this.parent = parent;
        this.qname = qname;
        int tmp = Objects.hashCode(parent);
        if (qname != null) {
            tmp = tmp * 31 + qname.hashCode();
        }
        this.hash = tmp;
    }

    private ImmutableList<QName> getLegacyPath() {
        ImmutableList<QName> ret = this.legacyPath;
        if (ret == null) {
            ArrayList<QName> tmp = new ArrayList<QName>();
            for (QName item : this.getPathTowardsRoot()) {
                tmp.add(item);
            }
            ret = ImmutableList.copyOf(Lists.reverse(tmp));
            LEGACYPATH_UPDATER.lazySet(this, ret);
        }
        return ret;
    }

    @Deprecated
    public List<QName> getPath() {
        return this.getLegacyPath();
    }

    public static @NonNull SchemaPath create(Iterable<QName> path, boolean absolute) {
        return (absolute ? ROOT : SAME).createChild(path);
    }

    public static @NonNull SchemaPath create(boolean absolute, QName element) {
        return (absolute ? ROOT : SAME).createChild(element);
    }

    public static @NonNull SchemaPath create(boolean absolute, QName ... path) {
        return SchemaPath.create(Arrays.asList(path), absolute);
    }

    public @NonNull SchemaPath createChild(Iterable<QName> relative) {
        if (Iterables.isEmpty(relative)) {
            return this;
        }
        SchemaPath parentPath = this;
        for (QName item : relative) {
            parentPath = parentPath.createChild(item);
        }
        return parentPath;
    }

    public @NonNull SchemaPath createChild(SchemaPath relative) {
        Preconditions.checkArgument(!relative.isAbsolute(), "Child creation requires relative path");
        return this.createChild(relative.getPathFromRoot());
    }

    public abstract @NonNull SchemaPath createChild(QName var1);

    public @NonNull SchemaPath createChild(QName ... elements) {
        return this.createChild(Arrays.asList(elements));
    }

    public Iterable<QName> getPathFromRoot() {
        return this.getLegacyPath();
    }

    public Iterable<QName> getPathTowardsRoot() {
        return () -> new UnmodifiableIterator<QName>(){
            private SchemaPath current;
            {
                this.current = SchemaPath.this;
            }

            @Override
            public boolean hasNext() {
                return this.current.parent != null;
            }

            @Override
            public QName next() {
                if (this.current.parent != null) {
                    QName ret = this.current.qname;
                    this.current = this.current.parent;
                    return ret;
                }
                throw new NoSuchElementException("No more elements available");
            }
        };
    }

    public SchemaPath getParent() {
        return this.parent;
    }

    public final QName getLastComponent() {
        return this.qname;
    }

    public abstract boolean isAbsolute();

    public final int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaPath other = (SchemaPath)obj;
        return Objects.equals(this.qname, other.qname) && Objects.equals(this.parent, other.parent);
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper(this)).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("path", this.getPathFromRoot());
    }

    private static final class RelativeSchemaPath
    extends SchemaPath {
        private RelativeSchemaPath(SchemaPath parent, QName qname) {
            super(parent, qname);
        }

        @Override
        public boolean isAbsolute() {
            return false;
        }

        @Override
        public RelativeSchemaPath createChild(QName element) {
            return new RelativeSchemaPath(this, Objects.requireNonNull(element));
        }
    }

    private static final class AbsoluteSchemaPath
    extends SchemaPath {
        private AbsoluteSchemaPath(SchemaPath parent, QName qname) {
            super(parent, qname);
        }

        @Override
        public boolean isAbsolute() {
            return true;
        }

        @Override
        public AbsoluteSchemaPath createChild(QName element) {
            return new AbsoluteSchemaPath(this, Objects.requireNonNull(element));
        }
    }
}

