/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.type;

import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.TypeDefinitions;

public interface EnumTypeDefinition
extends TypeDefinition<EnumTypeDefinition> {
    public @NonNull List<EnumPair> getValues();

    public static boolean equals(@NonNull EnumTypeDefinition type, @Nullable Object obj) {
        if (type == obj) {
            return true;
        }
        EnumTypeDefinition other = TypeDefinitions.castIfEquals(EnumTypeDefinition.class, type, obj);
        return other != null && type.getValues().equals(other.getValues());
    }

    public static int hashCode(@NonNull EnumTypeDefinition type) {
        return Objects.hash(type.getPath(), type.getUnknownSchemaNodes(), type.getBaseType(), type.getUnits().orElse(null), type.getDefaultValue(), type.getValues());
    }

    public static String toString(@NonNull EnumTypeDefinition type) {
        return TypeDefinitions.toStringHelper(type).add("values", type.getValues()).toString();
    }

    public static interface EnumPair
    extends DocumentedNode.WithStatus {
        public String getName();

        public int getValue();
    }
}

