/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import tech.pantheon.triemap.BasicNode;
import tech.pantheon.triemap.CNode;
import tech.pantheon.triemap.EntryNode;
import tech.pantheon.triemap.INode;
import tech.pantheon.triemap.ImmutableTrieMap;
import tech.pantheon.triemap.LNode;
import tech.pantheon.triemap.LNodeEntries;
import tech.pantheon.triemap.MainNode;
import tech.pantheon.triemap.SNode;
import tech.pantheon.triemap.TNode;
import tech.pantheon.triemap.TrieMap;

abstract class AbstractIterator<K, V>
implements Iterator<Map.Entry<K, V>> {
    private final BasicNode[][] nodeStack = new BasicNode[7][];
    private final int[] positionStack = new int[7];
    private final TrieMap<K, V> map;
    private LNodeEntries<K, V> lnode;
    private EntryNode<K, V> current;
    private int depth = -1;

    AbstractIterator(ImmutableTrieMap<K, V> map) {
        this.map = map;
        this.readin(map.readRoot());
    }

    @Override
    public final boolean hasNext() {
        return this.current != null || this.lnode != null;
    }

    @Override
    public final Map.Entry<K, V> next() {
        Map.Entry<K, V> entry;
        if (this.lnode != null) {
            entry = this.lnode;
            this.lnode = this.lnode.next();
            if (this.lnode == null) {
                this.advance();
            }
        } else {
            entry = this.current;
            this.advance();
        }
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return this.wrapEntry(entry);
    }

    abstract Map.Entry<K, V> wrapEntry(Map.Entry<K, V> var1);

    private void readin(INode<K, V> in) {
        MainNode<K, V> m3 = in.gcasRead(this.map);
        if (m3 instanceof CNode) {
            CNode cn = (CNode)m3;
            ++this.depth;
            this.nodeStack[this.depth] = cn.array;
            this.positionStack[this.depth] = -1;
            this.advance();
        } else if (m3 instanceof TNode) {
            this.current = (TNode)m3;
        } else if (m3 instanceof LNode) {
            this.lnode = ((LNode)m3).entries();
        } else if (m3 == null) {
            this.current = null;
        }
    }

    private void advance() {
        if (this.depth >= 0) {
            int npos = this.positionStack[this.depth] + 1;
            if (npos < this.nodeStack[this.depth].length) {
                this.positionStack[this.depth] = npos;
                BasicNode elem = this.nodeStack[this.depth][npos];
                if (elem instanceof SNode) {
                    this.current = (SNode)elem;
                } else if (elem instanceof INode) {
                    this.readin((INode)elem);
                }
            } else {
                --this.depth;
                this.advance();
            }
        } else {
            this.current = null;
        }
    }
}

