/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bgpcep.programming;

import java.util.concurrent.TimeUnit;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.Nanotime;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NanotimeUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NanotimeUtil.class);
    private static volatile Long nanoTimeOffset = null;

    private NanotimeUtil() {
    }

    public static Nanotime currentTime() {
        long millis = Uint64.valueOf(System.currentTimeMillis()).longValue();
        return new Nanotime(Uint64.fromLongBits(TimeUnit.MILLISECONDS.toNanos(millis)));
    }

    public static Nanotime currentNanoTime() {
        if (nanoTimeOffset == null) {
            NanotimeUtil.calibrate();
        }
        return new Nanotime(Uint64.fromLongBits(System.nanoTime() + nanoTimeOffset));
    }

    private static void calibrate() {
        long tm1 = System.currentTimeMillis();
        long nt1 = System.nanoTime();
        long tm2 = System.currentTimeMillis();
        long nt2 = System.nanoTime();
        LOG.debug("Calibrated currentTime and nanoTime to {}m <= {}n <= {}m <= {}n", tm1, nt1, tm2, nt2);
        long tm = (tm1 + tm2) / 2L;
        long nt = (nt1 + nt2) / 2L;
        nanoTimeOffset = TimeUnit.MILLISECONDS.toNanos(tm) - nt;
    }
}

