/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.spec.naming;

import com.google.common.annotations.Beta;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;

@Beta
public final class BindingMapping {
    public static final @NonNull String VERSION = "0.6";
    public static final ImmutableSet<String> JAVA_RESERVED_WORDS = ImmutableSet.of("abstract", "assert", "boolean", "break", "byte", "case", new String[]{"catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "_", "false", "true", "null"});
    public static final @NonNull String DATA_ROOT_SUFFIX = "Data";
    public static final @NonNull String RPC_SERVICE_SUFFIX = "Service";
    public static final @NonNull String NOTIFICATION_LISTENER_SUFFIX = "Listener";
    public static final @NonNull String QNAME_STATIC_FIELD_NAME = "QNAME";
    public static final @NonNull String PACKAGE_PREFIX = "org.opendaylight.yang.gen.v1";
    public static final @NonNull String AUGMENTATION_FIELD = "augmentation";
    private static final Splitter CAMEL_SPLITTER = Splitter.on(CharMatcher.anyOf(" _.-/").precomputed()).omitEmptyStrings().trimResults();
    private static final Pattern COLON_SLASH_SLASH = Pattern.compile("://", 16);
    private static final String QUOTED_DOT = Matcher.quoteReplacement(".");
    private static final Splitter DOT_SPLITTER = Splitter.on('.');
    public static final @NonNull String MODULE_INFO_CLASS_NAME = "$YangModuleInfoImpl";
    public static final @NonNull String MODULE_INFO_QNAMEOF_METHOD_NAME = "qnameOf";
    public static final @NonNull String MODEL_BINDING_PROVIDER_CLASS_NAME = "$YangModelBindingProvider";
    public static final @NonNull String AUGMENTABLE_AUGMENTATION_NAME = "augmentation";
    public static final @NonNull String IDENTIFIABLE_KEY_NAME = "key";
    public static final @NonNull String DATA_CONTAINER_IMPLEMENTED_INTERFACE_NAME = "implementedInterface";
    public static final @NonNull String BOOLEAN_GETTER_PREFIX = "is";
    public static final @NonNull String GETTER_PREFIX = "get";
    public static final @NonNull String NONNULL_PREFIX = "nonnull";
    public static final @NonNull String RPC_INPUT_SUFFIX = "Input";
    public static final @NonNull String RPC_OUTPUT_SUFFIX = "Output";
    private static final Interner<String> PACKAGE_INTERNER = Interners.newWeakInterner();

    private BindingMapping() {
        throw new UnsupportedOperationException("Utility class should not be instantiated");
    }

    public static @NonNull String getRootPackageName(QName module) {
        return BindingMapping.getRootPackageName(module.getModule());
    }

    public static @NonNull String getRootPackageName(QNameModule module) {
        Optional<Revision> optRev;
        StringBuilder packageNameBuilder = new StringBuilder().append(PACKAGE_PREFIX).append('.');
        String namespace = module.getNamespace().toString();
        namespace = COLON_SLASH_SLASH.matcher(namespace).replaceAll(QUOTED_DOT);
        char[] chars = namespace.toCharArray();
        block3: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '#': 
                case '$': 
                case '\'': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '@': {
                    chars[i] = 46;
                    continue block3;
                }
            }
        }
        packageNameBuilder.append(chars);
        if (chars[chars.length - 1] != '.') {
            packageNameBuilder.append('.');
        }
        if ((optRev = module.getRevision()).isPresent()) {
            String rev = optRev.get().toString();
            Preconditions.checkArgument(rev.length() == 10, "Unsupported revision %s", (Object)rev);
            packageNameBuilder.append("rev").append(rev, 2, 4).append(rev, 5, 7).append(rev.substring(8));
        } else {
            packageNameBuilder.append("norev");
        }
        return BindingMapping.normalizePackageName(packageNameBuilder.toString());
    }

    public static @NonNull String normalizePackageName(String packageName) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String p : DOT_SPLITTER.split(packageName.toLowerCase(Locale.ENGLISH))) {
            if (first) {
                first = false;
            } else {
                builder.append('.');
            }
            if (Character.isDigit(p.charAt(0)) || JAVA_RESERVED_WORDS.contains(p)) {
                builder.append('_');
            }
            builder.append(p);
        }
        return PACKAGE_INTERNER.intern(builder.toString());
    }

    public static @NonNull String getClassName(String localName) {
        return BindingMapping.toFirstUpper(BindingMapping.toCamelCase(localName));
    }

    public static @NonNull String getClassName(QName name) {
        return BindingMapping.toFirstUpper(BindingMapping.toCamelCase(name.getLocalName()));
    }

    public static @NonNull String getMethodName(String yangIdentifier) {
        return BindingMapping.toFirstLower(BindingMapping.toCamelCase(yangIdentifier));
    }

    public static @NonNull String getMethodName(QName name) {
        return BindingMapping.getMethodName(name.getLocalName());
    }

    public static @NonNull String getGetterPrefix(boolean isBoolean) {
        return isBoolean ? BOOLEAN_GETTER_PREFIX : GETTER_PREFIX;
    }

    public static @NonNull String getGetterMethodName(String localName, boolean isBoolean) {
        return BindingMapping.getGetterPrefix(isBoolean) + BindingMapping.toFirstUpper(BindingMapping.getPropertyName(localName));
    }

    public static @NonNull String getGetterMethodName(QName name, boolean isBoolean) {
        return BindingMapping.getGetterPrefix(isBoolean) + BindingMapping.getGetterSuffix(name);
    }

    public static boolean isGetterMethodName(String methodName) {
        return methodName.startsWith(GETTER_PREFIX) || methodName.startsWith(BOOLEAN_GETTER_PREFIX);
    }

    public static @NonNull String getGetterMethodForNonnull(String methodName) {
        Preconditions.checkArgument(BindingMapping.isNonnullMethodName(methodName));
        return GETTER_PREFIX + methodName.substring(NONNULL_PREFIX.length());
    }

    public static @NonNull String getNonnullMethodName(String localName) {
        return NONNULL_PREFIX + BindingMapping.toFirstUpper(BindingMapping.getPropertyName(localName));
    }

    public static boolean isNonnullMethodName(String methodName) {
        return methodName.startsWith(NONNULL_PREFIX);
    }

    public static @NonNull String getGetterSuffix(QName name) {
        String candidate = BindingMapping.toFirstUpper(BindingMapping.toCamelCase(name.getLocalName()));
        return "Class".equals(candidate) ? "XmlClass" : candidate;
    }

    public static @NonNull String getPropertyName(String yangIdentifier) {
        String potential = BindingMapping.toFirstLower(BindingMapping.toCamelCase(yangIdentifier));
        if ("class".equals(potential)) {
            return "xmlClass";
        }
        return potential;
    }

    private static @NonNull String toCamelCase(String rawString) {
        StringBuilder builder = new StringBuilder();
        for (String comp : CAMEL_SPLITTER.split(rawString)) {
            builder.append(BindingMapping.toFirstUpper(comp));
        }
        return BindingMapping.checkNumericPrefix(builder.toString());
    }

    private static @NonNull String checkNumericPrefix(String rawString) {
        if (rawString.isEmpty()) {
            return rawString;
        }
        char firstChar = rawString.charAt(0);
        return firstChar >= '0' && firstChar <= '9' ? "_" + rawString : rawString;
    }

    private static @NonNull String toFirstUpper(@NonNull String str) {
        if (str.isEmpty()) {
            return str;
        }
        if (Character.isUpperCase(str.charAt(0))) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase(Locale.ENGLISH);
        }
        return str.substring(0, 1).toUpperCase(Locale.ENGLISH) + str.substring(1);
    }

    private static @NonNull String toFirstLower(@NonNull String str) {
        if (str.isEmpty()) {
            return str;
        }
        if (Character.isLowerCase(str.charAt(0))) {
            return str;
        }
        if (str.length() == 1) {
            return str.toLowerCase(Locale.ENGLISH);
        }
        return str.substring(0, 1).toLowerCase(Locale.ENGLISH) + str.substring(1);
    }

    public static @NonNull String getRpcMethodName(@NonNull QName qname) {
        String methodName = BindingMapping.getMethodName(qname);
        return JAVA_RESERVED_WORDS.contains(methodName) ? methodName + "$" : methodName;
    }

    public static BiMap<String, String> mapEnumAssignedNames(Collection<String> assignedNames) {
        HashBiMap<String, String> javaToYang = HashBiMap.create(assignedNames.size());
        boolean valid = true;
        for (String name : assignedNames) {
            String mappedName;
            Preconditions.checkArgument(!name.isEmpty());
            if (javaToYang.containsValue(name) || BindingMapping.isValidJavaIdentifier(mappedName = BindingMapping.getClassName(name)) && javaToYang.forcePut(mappedName, name) == null) continue;
            valid = false;
            break;
        }
        if (!valid) {
            javaToYang.clear();
            for (String name : assignedNames) {
                javaToYang.put(BindingMapping.mapEnumAssignedName(name), name);
            }
        }
        return javaToYang.inverse();
    }

    private static boolean isValidJavaIdentifier(String str) {
        return !str.isEmpty() && !JAVA_RESERVED_WORDS.contains(str) && Character.isJavaIdentifierStart(str.codePointAt(0)) && str.codePoints().skip(1L).allMatch(Character::isJavaIdentifierPart);
    }

    private static String mapEnumAssignedName(String assignedName) {
        Preconditions.checkArgument(!assignedName.isEmpty());
        if (assignedName.indexOf(36) == -1 && BindingMapping.isValidJavaIdentifier(assignedName)) {
            return assignedName;
        }
        StringBuilder sb = new StringBuilder().append('$');
        assignedName.codePoints().forEachOrdered(codePoint -> {
            if (codePoint == 36 || !Character.isJavaIdentifierPart(codePoint)) {
                sb.append('$').append(Integer.toHexString(codePoint).toUpperCase(Locale.ROOT)).append('$');
            } else {
                sb.appendCodePoint(codePoint);
            }
        });
        return sb.toString();
    }
}

