/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.model.ietf.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.AbstractMap;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.spec.reflect.StringValueObjectFactory;
import org.opendaylight.mdsal.model.ietf.util.Ipv4Utils;
import org.opendaylight.mdsal.model.ietf.util.Ipv6Utils;

@Beta
public abstract class AbstractIetfInetUtil<A4, A4NZ extends A4, P4, A6, A6NZ extends A6, P6, A, ANZ, P> {
    private static final int INET4_LENGTH = 4;
    private static final int INET6_LENGTH = 16;
    private final StringValueObjectFactory<A4> address4Factory;
    private final StringValueObjectFactory<A4NZ> address4NoZoneFactory;
    private final StringValueObjectFactory<P4> prefix4Factory;
    private final StringValueObjectFactory<A6> address6Factory;
    private final StringValueObjectFactory<A6NZ> address6NoZoneFactory;
    private final StringValueObjectFactory<P6> prefix6Factory;
    private final Class<A4NZ> addr4nzClass;
    private final Class<A6NZ> addr6nzClass;

    protected AbstractIetfInetUtil(Class<A4> addr4Class, Class<A4NZ> addr4nzClass, Class<P4> prefix4Class, Class<A6> addr6Class, Class<A6NZ> addr6nzClass, Class<P6> prefix6Class) {
        this.addr4nzClass = Objects.requireNonNull(addr4nzClass);
        this.addr6nzClass = Objects.requireNonNull(addr6nzClass);
        this.address4Factory = StringValueObjectFactory.create(addr4Class, "0.0.0.0");
        this.address4NoZoneFactory = StringValueObjectFactory.create(addr4nzClass, "0.0.0.0");
        this.prefix4Factory = StringValueObjectFactory.create(prefix4Class, "0.0.0.0/0");
        this.address6Factory = StringValueObjectFactory.create(addr6Class, "::0");
        this.address6NoZoneFactory = StringValueObjectFactory.create(addr6nzClass, "::0");
        this.prefix6Factory = StringValueObjectFactory.create(prefix6Class, "::0/0");
    }

    protected abstract @NonNull A ipv4Address(@NonNull A4 var1);

    protected abstract @NonNull ANZ ipv4AddressNoZone(@NonNull A4NZ var1);

    protected abstract @NonNull A ipv6Address(@NonNull A6 var1);

    protected abstract @NonNull ANZ ipv6AddressNoZone(@NonNull A6NZ var1);

    protected abstract @Nullable A4 maybeIpv4Address(@NonNull A var1);

    protected abstract @Nullable A4NZ maybeIpv4AddressNoZone(@NonNull ANZ var1);

    protected abstract @Nullable A6 maybeIpv6Address(@NonNull A var1);

    protected abstract @Nullable A6NZ maybeIpv6AddressNoZone(@NonNull ANZ var1);

    protected abstract @NonNull P ipv4Prefix(@NonNull P4 var1);

    protected abstract @NonNull P ipv6Prefix(@NonNull P6 var1);

    protected abstract @NonNull String ipv4AddressString(@NonNull A4 var1);

    protected abstract @NonNull String ipv6AddressString(@NonNull A6 var1);

    protected abstract @NonNull String ipv4PrefixString(@NonNull P4 var1);

    protected abstract @NonNull String ipv6PrefixString(@NonNull P6 var1);

    public final @NonNull A ipAddressFor(byte @NonNull [] bytes) {
        switch (bytes.length) {
            case 4: {
                return this.ipv4Address(this.ipv4AddressFor(bytes));
            }
            case 16: {
                return this.ipv6Address(this.ipv6AddressFor(bytes));
            }
        }
        throw new IllegalArgumentException("Invalid array length " + bytes.length);
    }

    public final @NonNull A ipAddressFor(@NonNull InetAddress addr) {
        Objects.requireNonNull(addr, "Address must not be null");
        if (addr instanceof Inet4Address) {
            return this.ipv4Address(this.ipv4AddressFor(addr));
        }
        if (addr instanceof Inet6Address) {
            return this.ipv6Address(this.ipv6AddressFor(addr));
        }
        throw new IllegalArgumentException("Unhandled address " + addr);
    }

    public final @NonNull ANZ ipAddressNoZoneFor(byte @NonNull [] bytes) {
        switch (bytes.length) {
            case 4: {
                return this.ipv4AddressNoZone(this.ipv4AddressNoZoneFor((A4)bytes));
            }
            case 16: {
                return this.ipv6AddressNoZone(this.ipv6AddressNoZoneFor((A6)bytes));
            }
        }
        throw new IllegalArgumentException("Invalid array length " + bytes.length);
    }

    public final @NonNull ANZ ipAddressNoZoneFor(@NonNull InetAddress addr) {
        Objects.requireNonNull(addr, "Address must not be null");
        if (addr instanceof Inet4Address) {
            return this.ipv4AddressNoZone(this.ipv4AddressNoZoneFor((A4)addr));
        }
        if (addr instanceof Inet6Address) {
            return this.ipv6AddressNoZone(this.ipv6AddressNoZoneFor((A6)addr));
        }
        throw new IllegalArgumentException("Unhandled address " + addr);
    }

    public final @NonNull P ipPrefixFor(byte @NonNull [] bytes, int mask) {
        switch (bytes.length) {
            case 4: {
                return this.ipv4Prefix(this.ipv4PrefixFor((A4)bytes, mask));
            }
            case 16: {
                return this.ipv6Prefix(this.ipv6PrefixFor((A6)bytes, mask));
            }
        }
        throw new IllegalArgumentException("Invalid array length " + bytes.length);
    }

    public final @NonNull P ipPrefixFor(@NonNull InetAddress addr, int mask) {
        Objects.requireNonNull(addr, "Address must not be null");
        if (addr instanceof Inet4Address) {
            return this.ipv4Prefix(this.ipv4PrefixFor((A4)addr, mask));
        }
        if (addr instanceof Inet6Address) {
            return this.ipv6Prefix(this.ipv6PrefixFor((A6)addr, mask));
        }
        throw new IllegalArgumentException("Unhandled address " + addr);
    }

    public final @NonNull InetAddress inetAddressFor(@NonNull A addr) {
        A4 v4 = this.maybeIpv4Address(addr);
        if (v4 != null) {
            return this.inet4AddressFor(v4);
        }
        A6 v6 = this.maybeIpv6Address(addr);
        Preconditions.checkArgument(v6 != null, "Address %s is neither IPv4 nor IPv6", addr);
        return this.inet6AddressFor(v6);
    }

    public final @NonNull InetAddress inetAddressForNoZone(@NonNull ANZ addr) {
        A4NZ v4 = this.maybeIpv4AddressNoZone(addr);
        if (v4 != null) {
            return this.inet4AddressForNoZone(v4);
        }
        A6NZ v6 = this.maybeIpv6AddressNoZone(addr);
        Preconditions.checkArgument(v6 != null, "Address %s is neither IPv4 nor IPv6", addr);
        return this.inet6AddressForNoZone(v6);
    }

    public final @NonNull Inet4Address inet4AddressFor(@NonNull A4 addr) {
        try {
            return (Inet4Address)InetAddress.getByAddress(this.ipv4AddressBytes(addr));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid address " + addr, e);
        }
    }

    public final @NonNull Inet4Address inet4AddressForNoZone(@NonNull A4NZ addr) {
        try {
            return (Inet4Address)InetAddress.getByAddress(this.ipv4AddressNoZoneBytes(addr));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid address " + addr, e);
        }
    }

    public final @NonNull Inet6Address inet6AddressFor(@NonNull A6 addr) {
        try {
            return (Inet6Address)InetAddress.getByAddress(this.ipv6AddressBytes(addr));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid address " + addr, e);
        }
    }

    public final @NonNull Inet6Address inet6AddressForNoZone(@NonNull A6NZ addr) {
        try {
            return (Inet6Address)InetAddress.getByAddress(this.ipv6AddressNoZoneBytes(addr));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid address " + addr, e);
        }
    }

    public final @NonNull A4 ipv4AddressFor(byte @NonNull [] bytes) {
        return this.address4Factory.newInstance(AbstractIetfInetUtil.addressStringV4(bytes));
    }

    public final @NonNull A4 ipv4AddressFor(@NonNull InetAddress addr) {
        Objects.requireNonNull(addr, "Address must not be null");
        Preconditions.checkArgument(addr instanceof Inet4Address, "Address has to be an Inet4Address");
        return this.address4Factory.newInstance(addr.getHostAddress());
    }

    public final @NonNull A4 ipv4AddressFor(int bits) {
        return this.address4Factory.newInstance(Ipv4Utils.addressString(bits));
    }

    public final @NonNull A4NZ ipv4AddressNoZoneFor(byte @NonNull [] bytes) {
        return this.address4NoZoneFactory.newInstance(AbstractIetfInetUtil.addressStringV4(bytes));
    }

    public final @NonNull A4NZ ipv4AddressNoZoneFor(@NonNull InetAddress addr) {
        Objects.requireNonNull(addr, "Address must not be null");
        Preconditions.checkArgument(addr instanceof Inet4Address, "Address has to be an Inet4Address");
        return this.address4NoZoneFactory.newInstance(addr.getHostAddress());
    }

    public final @NonNull A4NZ ipv4AddressNoZoneFor(int bits) {
        return this.address4NoZoneFactory.newInstance(Ipv4Utils.addressString(bits));
    }

    public final @NonNull A4NZ ipv4AddressNoZoneFor(@NonNull A4 addr) {
        Objects.requireNonNull(addr, "Address must not be null");
        return this.addr4nzClass.isInstance(addr) ? this.addr4nzClass.cast(addr) : this.address4NoZoneFactory.newInstance(AbstractIetfInetUtil.stripZone(this.ipv4AddressString(addr)));
    }

    public final @NonNull A4 ipv4AddressFrom(@NonNull P4 prefix) {
        return AbstractIetfInetUtil.prefixToAddress(this.address4Factory, this.ipv4PrefixString(prefix));
    }

    public final @NonNull A4NZ ipv4AddressNoZoneFrom(@NonNull P4 prefix) {
        return AbstractIetfInetUtil.prefixToAddress(this.address4NoZoneFactory, this.ipv4PrefixString(prefix));
    }

    public final byte @NonNull [] ipv4AddressBytes(@NonNull A4 addr) {
        String str;
        int percent = (str = this.ipv4AddressString(addr)).indexOf(37);
        return Ipv4Utils.addressBytes(str, percent == -1 ? str.length() : percent);
    }

    public final int ipv4AddressBits(@NonNull A4 addr) {
        String str;
        int percent = (str = this.ipv4AddressString(addr)).indexOf(37);
        return Ipv4Utils.addressBits(str, percent == -1 ? str.length() : percent);
    }

    public final byte @NonNull [] ipv4AddressNoZoneBytes(@NonNull A4NZ addr) {
        String str = this.ipv4AddressString(addr);
        return Ipv4Utils.addressBytes(str, str.length());
    }

    public final int ipv4AddressNoZoneBits(@NonNull A4NZ addr) {
        String str = this.ipv4AddressString(addr);
        return Ipv4Utils.addressBits(str, str.length());
    }

    public final @NonNull P4 ipv4PrefixFor(byte @NonNull [] bytes) {
        return this.prefix4Factory.newInstance(AbstractIetfInetUtil.prefixStringV4(bytes));
    }

    public final @NonNull P4 ipv4PrefixFor(byte @NonNull [] address, int mask) {
        return this.prefix4Factory.newInstance(AbstractIetfInetUtil.prefixStringV4(address, mask));
    }

    public final @NonNull P4 ipv4PrefixFor(@NonNull InetAddress addr) {
        Objects.requireNonNull(addr, "Address must not be null");
        Preconditions.checkArgument(addr instanceof Inet4Address, "Address has to be an Inet4Address");
        return this.prefix4Factory.newInstance(addr.getHostAddress() + "/32");
    }

    public final @NonNull P4 ipv4PrefixFor(@NonNull InetAddress addr, int mask) {
        Objects.requireNonNull(addr, "Address must not be null");
        Preconditions.checkArgument(addr instanceof Inet4Address, "Address has to be an Inet4Address");
        return this.newIpv4Prefix(addr.getHostAddress(), mask);
    }

    public final @NonNull P4 ipv4PrefixFor(@NonNull A4 addr) {
        Objects.requireNonNull(addr, "Address must not be null");
        return this.prefix4Factory.newInstance(AbstractIetfInetUtil.stripZone(this.ipv4AddressString(addr)) + "/32");
    }

    public final @NonNull P4 ipv4PrefixFor(@NonNull A4 addr, int mask) {
        Objects.requireNonNull(addr, "Address must not be null");
        return this.newIpv4Prefix(AbstractIetfInetUtil.stripZone(this.ipv4AddressString(addr)), mask);
    }

    public final @NonNull P4 ipv4PrefixForNoZone(@NonNull A4NZ addr) {
        Objects.requireNonNull(addr, "Address must not be null");
        return this.prefix4Factory.newInstance(this.ipv4AddressString(addr) + "/32");
    }

    public final @NonNull P4 ipv4PrefixForNoZone(@NonNull A4NZ addr, int mask) {
        Objects.requireNonNull(addr, "Address must not be null");
        return this.newIpv4Prefix(this.ipv4AddressString(addr), mask);
    }

    public final @NonNull P4 ipv4PrefixForShort(byte @NonNull [] address, int mask) {
        if (mask == 0) {
            return this.prefix4Factory.getTemplate();
        }
        return this.v4PrefixForShort(address, 0, mask / 8 + (mask % 8 == 0 ? 0 : 1), mask);
    }

    public final @NonNull P4 ipv4PrefixForShort(byte @NonNull [] array, int startOffset, int mask) {
        if (mask == 0) {
            return this.prefix4Factory.getTemplate();
        }
        return this.v4PrefixForShort(array, startOffset, mask / 8 + (mask % 8 == 0 ? 0 : 1), mask);
    }

    private static String stripZone(String str) {
        int percent = str.indexOf(37);
        return percent == -1 ? str : str.substring(0, percent);
    }

    private @NonNull P4 newIpv4Prefix(String addr, int mask) {
        Preconditions.checkArgument(mask >= 0 && mask <= 32, "Invalid mask %s", mask);
        return this.prefix4Factory.newInstance(addr + "/" + mask);
    }

    public final  @NonNull Map.Entry<A4, Integer> splitIpv4Prefix(@NonNull P4 prefix) {
        return AbstractIetfInetUtil.splitPrefix(this.address4Factory, this.ipv4PrefixString(prefix));
    }

    public final  @NonNull Map.Entry<A4NZ, Integer> splitIpv4PrefixNoZone(@NonNull P4 prefix) {
        return AbstractIetfInetUtil.splitPrefix(this.address4NoZoneFactory, this.ipv4PrefixString(prefix));
    }

    public final byte @NonNull [] ipv4PrefixToBytes(@NonNull P4 prefix) {
        String str = this.ipv4PrefixString(prefix);
        int slash = str.lastIndexOf(47);
        byte[] bytes = new byte[5];
        Ipv4Utils.fillIpv4Bytes(bytes, 0, str, 0, slash);
        bytes[4] = (byte)Integer.parseInt(str.substring(slash + 1), 10);
        return bytes;
    }

    public final @NonNull A6 ipv6AddressFor(byte @NonNull [] bytes) {
        return this.address6Factory.newInstance(AbstractIetfInetUtil.addressStringV6(bytes));
    }

    public final @NonNull A6 ipv6AddressFor(@NonNull InetAddress addr) {
        return this.address6Factory.newInstance(AbstractIetfInetUtil.addressStringV6(addr));
    }

    public final @NonNull A6NZ ipv6AddressNoZoneFor(byte @NonNull [] bytes) {
        return this.address6NoZoneFactory.newInstance(AbstractIetfInetUtil.addressStringV6(bytes));
    }

    public final @NonNull A6NZ ipv6AddressNoZoneFor(@NonNull InetAddress addr) {
        return this.address6NoZoneFactory.newInstance(AbstractIetfInetUtil.addressStringV6(addr));
    }

    public final @NonNull A6NZ ipv6AddressNoZoneFor(@NonNull A6 addr) {
        Objects.requireNonNull(addr, "Address must not be null");
        return this.addr6nzClass.isInstance(addr) ? this.addr6nzClass.cast(addr) : this.address6NoZoneFactory.newInstance(AbstractIetfInetUtil.stripZone(this.ipv6AddressString(addr)));
    }

    public final @NonNull A6 ipv6AddressFrom(@NonNull P6 prefix) {
        return AbstractIetfInetUtil.prefixToAddress(this.address6Factory, this.ipv6PrefixString(prefix));
    }

    public final @NonNull A6NZ ipv6AddressNoZoneFrom(@NonNull P6 prefix) {
        return AbstractIetfInetUtil.prefixToAddress(this.address6NoZoneFactory, this.ipv6PrefixString(prefix));
    }

    public final byte @NonNull [] ipv6AddressBytes(@NonNull A6 addr) {
        String str;
        int percent = (str = this.ipv6AddressString(addr)).indexOf(37);
        return AbstractIetfInetUtil.ipv6StringBytes(str, percent == -1 ? str.length() : percent);
    }

    public final byte @NonNull [] ipv6AddressNoZoneBytes(@NonNull A6NZ addr) {
        String str = this.ipv6AddressString(addr);
        return AbstractIetfInetUtil.ipv6StringBytes(str, str.length());
    }

    private static byte @NonNull [] ipv6StringBytes(@NonNull String str, int limit) {
        byte[] bytes = new byte[16];
        Ipv6Utils.fillIpv6Bytes(bytes, str, limit);
        return bytes;
    }

    public final @NonNull P6 ipv6PrefixFor(byte @NonNull [] bytes) {
        return this.prefix6Factory.newInstance(AbstractIetfInetUtil.addressStringV6(bytes) + "/128");
    }

    public final @NonNull P6 ipv6PrefixFor(byte @NonNull [] address, int mask) {
        Preconditions.checkArgument(mask >= 0 && mask <= 128, "Invalid mask %s", mask);
        return this.prefix6Factory.newInstance(AbstractIetfInetUtil.addressStringV6(address) + "/" + mask);
    }

    public final @NonNull P6 ipv6PrefixFor(@NonNull InetAddress addr) {
        return this.prefix6Factory.newInstance(AbstractIetfInetUtil.addressStringV6(addr) + "/128");
    }

    public final @NonNull P6 ipv6PrefixFor(@NonNull InetAddress addr, int mask) {
        Preconditions.checkArgument(mask >= 0 && mask <= 128, "Invalid mask %s", mask);
        return this.prefix6Factory.newInstance(AbstractIetfInetUtil.addressStringV6(addr) + "/" + mask);
    }

    public final @NonNull P6 ipv6PrefixFor(@NonNull A6 addr) {
        Objects.requireNonNull(addr, "Address must not be null");
        return this.prefix6Factory.newInstance(AbstractIetfInetUtil.stripZone(this.ipv6AddressString(addr)) + "/128");
    }

    public final @NonNull P6 ipv6PrefixFor(@NonNull A6 addr, int mask) {
        Objects.requireNonNull(addr, "Address must not be null");
        return this.newIpv6Prefix(AbstractIetfInetUtil.stripZone(this.ipv6AddressString(addr)), mask);
    }

    public final @NonNull P6 ipv6PrefixForNoZone(@NonNull A6NZ addr) {
        Objects.requireNonNull(addr, "Address must not be null");
        return this.prefix6Factory.newInstance(this.ipv6AddressString(addr) + "/128");
    }

    public final @NonNull P6 ipv6PrefixForNoZone(@NonNull A6NZ addr, int mask) {
        Objects.requireNonNull(addr, "Address must not be null");
        return this.newIpv6Prefix(this.ipv6AddressString(addr), mask);
    }

    public final @NonNull P6 ipv6PrefixForShort(byte @NonNull [] address, int mask) {
        return this.ipv6PrefixForShort(address, 0, mask);
    }

    public final @NonNull P6 ipv6PrefixForShort(byte @NonNull [] array, int startOffset, int mask) {
        if (mask == 0) {
            return this.prefix6Factory.getTemplate();
        }
        Preconditions.checkArgument(mask > 0 && mask <= 128, "Invalid mask %s", mask);
        int size = mask / 8 + (mask % 8 == 0 ? 0 : 1);
        byte[] tmp = new byte[16];
        System.arraycopy(array, startOffset, tmp, 0, size);
        return this.ipv6PrefixFor((A6)tmp, mask);
    }

    private P6 newIpv6Prefix(String addr, int mask) {
        Preconditions.checkArgument(mask >= 0 && mask <= 128, "Invalid mask %s", mask);
        return this.prefix6Factory.newInstance(addr + "/" + mask);
    }

    public final  @NonNull Map.Entry<A6, Integer> splitIpv6Prefix(@NonNull P6 prefix) {
        return AbstractIetfInetUtil.splitPrefix(this.address6Factory, this.ipv6PrefixString(prefix));
    }

    public final  @NonNull Map.Entry<A6NZ, Integer> splitIpv6PrefixNoZone(@NonNull P6 prefix) {
        return AbstractIetfInetUtil.splitPrefix(this.address6NoZoneFactory, this.ipv6PrefixString(prefix));
    }

    private static <T> @NonNull T prefixToAddress(StringValueObjectFactory<T> factory, String str) {
        return factory.newInstance(str.substring(0, str.lastIndexOf(47)));
    }

    private static <T>  @NonNull Map.Entry<T, Integer> splitPrefix(StringValueObjectFactory<T> factory, String str) {
        int slash = str.lastIndexOf(47);
        return new AbstractMap.SimpleImmutableEntry<T, Integer>(factory.newInstance(str.substring(0, slash)), Integer.valueOf(str.substring(slash + 1)));
    }

    public final byte @NonNull [] ipv6PrefixToBytes(@NonNull P6 prefix) {
        String str = this.ipv6PrefixString(prefix);
        byte[] bytes = new byte[17];
        int slash = str.lastIndexOf(47);
        Ipv6Utils.fillIpv6Bytes(bytes, str, slash);
        bytes[16] = (byte)Integer.parseInt(str.substring(slash + 1), 10);
        return bytes;
    }

    private static void appendIpv4String(StringBuilder sb, byte @NonNull [] bytes) {
        Preconditions.checkArgument(bytes.length == 4, "IPv4 address length is 4 bytes");
        sb.append(Byte.toUnsignedInt(bytes[0]));
        for (int i = 1; i < 4; ++i) {
            sb.append('.').append(Byte.toUnsignedInt(bytes[i]));
        }
    }

    static String addressStringV4(byte @NonNull [] bytes) {
        StringBuilder sb = new StringBuilder(15);
        AbstractIetfInetUtil.appendIpv4String(sb, bytes);
        return sb.toString();
    }

    private static String addressStringV6(byte @NonNull [] bytes) {
        Preconditions.checkArgument(bytes.length == 16, "IPv6 address length is 16 bytes");
        try {
            return AbstractIetfInetUtil.addressStringV6(Inet6Address.getByAddress(null, bytes, null));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(String.format("Invalid input %s", new Object[]{bytes}), e);
        }
    }

    private static String addressStringV6(InetAddress addr) {
        Objects.requireNonNull(addr, "Address must not be null");
        Preconditions.checkArgument(addr instanceof Inet6Address, "Address has to be an Inet6Address");
        return AbstractIetfInetUtil.addressStringV6((Inet6Address)addr);
    }

    private static String addressStringV6(Inet6Address addr) {
        return InetAddresses.toAddrString(addr);
    }

    private static String prefixStringV4(byte @NonNull [] bytes) {
        StringBuilder sb = new StringBuilder(18);
        AbstractIetfInetUtil.appendIpv4String(sb, bytes);
        return sb.append("/32").toString();
    }

    private static String prefixStringV4(byte @NonNull [] bytes, int mask) {
        Preconditions.checkArgument(mask >= 0 && mask <= 32, "Invalid mask %s", mask);
        StringBuilder sb = new StringBuilder(18);
        AbstractIetfInetUtil.appendIpv4String(sb, bytes);
        return sb.append('/').append(mask).toString();
    }

    private P4 v4PrefixForShort(byte @NonNull [] array, int startOffset, int size, int mask) {
        int i;
        if (startOffset == 0 && size == 4 && array.length == 4) {
            return this.ipv4PrefixFor((A4)array, mask);
        }
        StringBuilder sb = new StringBuilder(18);
        sb.append(Byte.toUnsignedInt(array[startOffset]));
        for (i = 1; i < size; ++i) {
            sb.append('.').append(Byte.toUnsignedInt(array[startOffset + i]));
        }
        for (i = size; i < 4; ++i) {
            sb.append(".0");
        }
        Preconditions.checkArgument(mask > 0 && mask <= 32, "Invalid mask %s", mask);
        sb.append('/').append(mask);
        return this.prefix4Factory.newInstance(sb.toString());
    }
}

