/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.model.ietf.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.spec.reflect.StringValueObjectFactory;
import org.opendaylight.mdsal.model.ietf.util.AbstractIetfInetUtil;
import org.opendaylight.mdsal.model.ietf.util.Ipv4Utils;

@Beta
public abstract class AbstractIetfYangUtil<M, P, H, Q, U> {
    private static final int MAC_BYTE_LENGTH = 6;
    private static final char[] HEX_CHARS;
    private static final byte @NonNull [] EMPTY_BYTES;
    private static final byte @NonNull [] HEX_VALUES;
    private final StringValueObjectFactory<M> macFactory;
    private final StringValueObjectFactory<P> physFactory;
    private final StringValueObjectFactory<H> hexFactory;
    private final StringValueObjectFactory<Q> quadFactory;
    private final StringValueObjectFactory<U> uuidFactory;

    protected AbstractIetfYangUtil(Class<M> macClass, Class<P> physClass, Class<H> hexClass, Class<Q> quadClass, Class<U> uuidClass) {
        this.macFactory = StringValueObjectFactory.create(macClass, "00:00:00:00:00:00");
        this.physFactory = StringValueObjectFactory.create(physClass, "00:00");
        this.hexFactory = StringValueObjectFactory.create(hexClass, "00");
        this.quadFactory = StringValueObjectFactory.create(quadClass, "0.0.0.0");
        this.uuidFactory = StringValueObjectFactory.create(uuidClass, "f81d4fae-7dec-11d0-a765-00a0c91e6bf6");
    }

    public final @NonNull M canonizeMacAddress(@NonNull M macAddress) {
        char[] input = this.getValue(macAddress).toCharArray();
        return AbstractIetfYangUtil.ensureLowerCase(input) ? this.macFactory.newInstance(String.valueOf(input)) : macAddress;
    }

    public final @NonNull M macAddressFor(byte @NonNull [] bytes) {
        Preconditions.checkArgument(bytes.length == 6, "MAC address should have 6 bytes, not %s", bytes.length);
        return this.macFactory.newInstance(AbstractIetfYangUtil.bytesToString(bytes, 17));
    }

    public final byte @NonNull [] macAddressBytes(@NonNull M macAddress) {
        return AbstractIetfYangUtil.stringToBytes(this.getValue(macAddress), 6);
    }

    public final @NonNull P canonizePhysAddress(@NonNull P physAddress) {
        char[] input = this.getPhysValue(physAddress).toCharArray();
        return AbstractIetfYangUtil.ensureLowerCase(input) ? this.physFactory.newInstance(String.valueOf(input)) : physAddress;
    }

    public final @NonNull P physAddressFor(byte @NonNull [] bytes) {
        Preconditions.checkArgument(bytes.length > 0, "Physical address should have at least one byte");
        return this.physFactory.newInstance(AbstractIetfYangUtil.bytesToString(bytes, bytes.length * 3 - 1));
    }

    public final byte @NonNull [] physAddressBytes(@NonNull P physAddress) {
        String str = this.getPhysValue(physAddress);
        return str.isEmpty() ? EMPTY_BYTES : AbstractIetfYangUtil.stringToBytes(str, str.length() / 3 + 1);
    }

    @Deprecated
    public final byte @NonNull [] bytesFor(@NonNull M macAddress) {
        return this.macAddressBytes(macAddress);
    }

    public final @NonNull H hexStringFor(byte @NonNull [] bytes) {
        Preconditions.checkArgument(bytes.length > 0, "Hex string should have at least one byte");
        return this.hexFactory.newInstance(AbstractIetfYangUtil.bytesToString(bytes, bytes.length * 3 - 1));
    }

    public final byte @NonNull [] hexStringBytes(@NonNull H hexString) {
        String str = this.getHexValue(hexString);
        return AbstractIetfYangUtil.stringToBytes(str, str.length() / 3 + 1);
    }

    public final @NonNull Q dottedQuadFor(byte @NonNull [] bytes) {
        Preconditions.checkArgument(bytes.length == 4, "Dotted-quad should have 4 bytes");
        return this.quadFactory.newInstance(AbstractIetfInetUtil.addressStringV4(bytes));
    }

    public final @NonNull Q dottedQuadFor(int bits) {
        return this.quadFactory.newInstance(Ipv4Utils.addressString(bits));
    }

    public final int dottedQuadBits(@NonNull Q dottedQuad) {
        String str = this.getQuadValue(dottedQuad);
        return Ipv4Utils.addressBits(str, str.length());
    }

    public final byte @NonNull [] dottedQuadBytes(@NonNull Q dottedQuad) {
        String str = this.getQuadValue(dottedQuad);
        return Ipv4Utils.addressBytes(str, str.length());
    }

    public final @NonNull U uuidFor(@NonNull UUID uuid) {
        return this.uuidFactory.newInstance(uuid.toString());
    }

    protected abstract String getValue(M var1);

    protected abstract String getPhysValue(P var1);

    protected abstract String getHexValue(H var1);

    protected abstract String getQuadValue(Q var1);

    static byte hexValue(char ch) {
        byte value;
        try {
            value = HEX_VALUES[ch];
        }
        catch (IndexOutOfBoundsException e) {
            value = -1;
        }
        if (value < 0) {
            throw new IllegalArgumentException("Invalid character '" + ch + "' encountered");
        }
        return value;
    }

    private static boolean ensureLowerCase(char @NonNull [] chars) {
        boolean ret = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c < 'A' || c > 'F') continue;
            chars[i] = Character.toLowerCase(c);
            ret = true;
        }
        return ret;
    }

    private static @NonNull String bytesToString(byte @NonNull [] bytes, int charHint) {
        StringBuilder sb = new StringBuilder(charHint);
        AbstractIetfYangUtil.appendHexByte(sb, bytes[0]);
        for (int i = 1; i < bytes.length; ++i) {
            AbstractIetfYangUtil.appendHexByte(sb.append(':'), bytes[i]);
        }
        return sb.toString();
    }

    private static void appendHexByte(StringBuilder sb, byte byteVal) {
        int intVal = Byte.toUnsignedInt(byteVal);
        sb.append(HEX_CHARS[intVal >>> 4]).append(HEX_CHARS[intVal & 0xF]);
    }

    private static byte @NonNull [] stringToBytes(String str, int length) {
        byte[] ret = new byte[length];
        int i = 0;
        int base = 0;
        while (i < length) {
            ret[i] = (byte)(AbstractIetfYangUtil.hexValue(str.charAt(base)) << 4 | AbstractIetfYangUtil.hexValue(str.charAt(base + 1)));
            ++i;
            base += 3;
        }
        return ret;
    }

    static {
        int c;
        HEX_CHARS = "0123456789abcdef".toCharArray();
        EMPTY_BYTES = new byte[0];
        byte[] b = new byte[103];
        Arrays.fill(b, (byte)-1);
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            b[c] = (byte)(c - 48);
        }
        for (c = 65; c <= 70; c = (int)((char)(c + 1))) {
            b[c] = (byte)(c - 65 + 10);
        }
        for (c = 97; c <= 102; c = (int)((char)(c + 1))) {
            b[c] = (byte)(c - 97 + 10);
        }
        HEX_VALUES = b;
    }
}

