/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.model.ietf.util;

import org.eclipse.jdt.annotation.NonNull;

final class Ipv4Utils {
    private Ipv4Utils() {
    }

    static void fillIpv4Bytes(byte @NonNull [] bytes, int byteStart, String str, int strStart, int strLimit) {
        int out = byteStart;
        int val = 0;
        for (int i = strStart; i < strLimit; ++i) {
            char c = str.charAt(i);
            if (c == '.') {
                bytes[out++] = (byte)val;
                val = 0;
                continue;
            }
            val = 10 * val + c - 48;
        }
        bytes[out] = (byte)val;
    }

    static int addressBits(String str, int limit) {
        int prev = 0;
        int current = 0;
        for (int i = 0; i < limit; ++i) {
            char c = str.charAt(i);
            if (c == '.') {
                prev = prev << 8 | current;
                current = 0;
                continue;
            }
            current = 10 * current + c - 48;
        }
        return prev << 8 | current;
    }

    static byte @NonNull [] addressBytes(String str, int limit) {
        byte[] bytes = new byte[4];
        Ipv4Utils.fillIpv4Bytes(bytes, 0, str, 0, limit);
        return bytes;
    }

    static String addressString(int bits) {
        return new StringBuilder(15).append(bits >>> 24).append('.').append(bits >>> 16 & 0xFF).append('.').append(bits >>> 8 & 0xFF).append('.').append(bits & 0xFF).toString();
    }
}

