/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.ietf.stateful07;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.MplsLabel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.path.binding.tlv.PathBinding;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.path.binding.tlv.PathBindingBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.path.binding.tlv.path.binding.BindingTypeValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.path.binding.tlv.path.binding.binding.type.value.MplsLabelBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.path.binding.tlv.path.binding.binding.type.value.MplsLabelEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.path.binding.tlv.path.binding.binding.type.value.MplsLabelEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint8;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public final class PathBindingTlvParser
implements TlvParser,
TlvSerializer {
    public static final int TYPE = 31;
    private static final Uint16 MPLS_LABEL = Uint16.ZERO;
    private static final Uint16 MPLS_STACK_ENTRY = Uint16.ONE;
    private static final int LABEL_MASK = 1048575;
    private static final int TC_MASK = 7;
    private static final int S_MASK = 1;
    private static final int TTL_MASK = 255;
    private static final int LABEL_SHIFT = 12;
    private static final int TC_SHIFT = 9;
    private static final int S_SHIFT = 8;
    private static final int MPLS_BINDING_LENGTH = 6;
    private static final Map<Uint16, PathBindingTlvCodec> BT_PARSERS;
    private static final Map<Class<? extends BindingTypeValue>, PathBindingTlvCodec> BT_SERIALIZERS;

    @Override
    public void serializeTlv(Tlv tlv, ByteBuf buffer) {
        Preconditions.checkArgument(tlv instanceof PathBinding, "The TLV must be PathBinding type, but was %s", tlv.getClass());
        PathBinding pTlv = (PathBinding)tlv;
        BindingTypeValue bindingTypeValue = pTlv.getBindingTypeValue();
        Preconditions.checkArgument(bindingTypeValue != null, "Missing Binding Value in Path Bidning TLV: %s", (Object)pTlv);
        ByteBuf body = Unpooled.buffer(6);
        PathBindingTlvCodec codec = BT_SERIALIZERS.get(bindingTypeValue.implementedInterface());
        Preconditions.checkArgument(codec != null, "Unsupported Path Binding Type: %s", bindingTypeValue.implementedInterface());
        codec.writeBinding(body, bindingTypeValue);
        TlvUtil.formatTlv(31, body, buffer);
    }

    @Override
    public Tlv parseTlv(ByteBuf buffer) throws PCEPDeserializerException {
        if (buffer == null) {
            return null;
        }
        Uint16 type = ByteBufUtils.readUint16(buffer);
        PathBindingTlvCodec codec = BT_PARSERS.get(type);
        if (codec == null) {
            throw new PCEPDeserializerException("Unsupported Path Binding Type: " + type);
        }
        return new PathBindingBuilder().setBindingTypeValue(codec.readEntry(buffer)).build();
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private static MplsLabel getMplsLabel(long mplsStackEntry) {
        return new MplsLabel(Uint32.valueOf(mplsStackEntry >> 12 & 0xFFFFFL));
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private static long getMplsStackEntry(MplsLabel mplsLabel) {
        return mplsLabel.getValue().toJava() << 12;
    }

    static {
        MplsLabelCodec mplsLabelCodec = new MplsLabelCodec();
        MplsLabelEntryCodec mplsLabelEntryCodec = new MplsLabelEntryCodec();
        ImmutableMap.Builder<Uint16, PathBindingTlvCodec> parsers = ImmutableMap.builder();
        ImmutableMap.Builder<Class, PathBindingTlvCodec> serializers = ImmutableMap.builder();
        parsers.put(mplsLabelCodec.getBindingType(), mplsLabelCodec);
        serializers.put(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.path.binding.tlv.path.binding.binding.type.value.MplsLabel.class, mplsLabelCodec);
        parsers.put(mplsLabelEntryCodec.getBindingType(), mplsLabelEntryCodec);
        serializers.put(MplsLabelEntry.class, mplsLabelEntryCodec);
        BT_PARSERS = parsers.build();
        BT_SERIALIZERS = serializers.build();
    }

    private static abstract class PathBindingTlvCodec {
        private final @NonNull Uint16 bindingType;

        PathBindingTlvCodec(Uint16 bindingType) {
            this.bindingType = Objects.requireNonNull(bindingType);
        }

        final @NonNull Uint16 getBindingType() {
            return this.bindingType;
        }

        final void writeBinding(ByteBuf buf, BindingTypeValue binding) {
            ByteBufUtils.writeMandatory(buf, this.bindingType, "bindingType");
            this.writeEntry(buf, binding);
        }

        abstract BindingTypeValue readEntry(ByteBuf var1);

        abstract void writeEntry(ByteBuf var1, BindingTypeValue var2);
    }

    private static final class MplsLabelEntryCodec
    extends PathBindingTlvCodec {
        MplsLabelEntryCodec() {
            super(MPLS_STACK_ENTRY);
        }

        @Override
        void writeEntry(ByteBuf buf, BindingTypeValue bindingValue) {
            Preconditions.checkArgument(bindingValue instanceof MplsLabelEntry, "bindingValue is not MplsLabelEntry");
            MplsLabelEntry mplsEntry = (MplsLabelEntry)bindingValue;
            long entry = PathBindingTlvParser.getMplsStackEntry(mplsEntry.getLabel()) | (long)(mplsEntry.getTrafficClass().toJava() << 9) | (long)((mplsEntry.isBottomOfStack() != false ? 1 : 0) << 8) | (long)mplsEntry.getTimeToLive().toJava();
            ByteBufUtils.write(buf, Uint32.valueOf(entry));
        }

        @Override
        BindingTypeValue readEntry(ByteBuf buffer) {
            long entry = buffer.readUnsignedInt();
            return new MplsLabelEntryBuilder().setLabel(PathBindingTlvParser.getMplsLabel(entry)).setTrafficClass(Uint8.valueOf(entry >> 9 & 7L)).setBottomOfStack((entry >> 8 & 1L) == 1L).setTimeToLive(Uint8.valueOf(entry & 0xFFL)).build();
        }
    }

    private static final class MplsLabelCodec
    extends PathBindingTlvCodec {
        MplsLabelCodec() {
            super(MPLS_LABEL);
        }

        @Override
        void writeEntry(ByteBuf buf, BindingTypeValue bindingValue) {
            Preconditions.checkArgument(bindingValue instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.path.binding.tlv.path.binding.binding.type.value.MplsLabel, "bindingValue is not MplsLabel");
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.path.binding.tlv.path.binding.binding.type.value.MplsLabel mplsLabel = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.path.binding.tlv.path.binding.binding.type.value.MplsLabel)bindingValue;
            ByteBufUtils.write(buf, Uint32.valueOf(PathBindingTlvParser.getMplsStackEntry(mplsLabel.getMplsLabel())));
        }

        @Override
        BindingTypeValue readEntry(ByteBuf buffer) {
            return new MplsLabelBuilder().setMplsLabel(PathBindingTlvParser.getMplsLabel(buffer.readUnsignedInt())).build();
        }
    }
}

