/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.ietf.stateful07;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.protocol.util.Ipv6Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.rsvp.error.spec.tlv.RsvpErrorSpec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.rsvp.error.spec.tlv.RsvpErrorSpecBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.rsvp.error.spec.tlv.rsvp.error.spec.ErrorType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.rsvp.error.spec.tlv.rsvp.error.spec.error.type.RsvpCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.rsvp.error.spec.tlv.rsvp.error.spec.error.type.RsvpCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.rsvp.error.spec.tlv.rsvp.error.spec.error.type.UserCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.rsvp.error.spec.tlv.rsvp.error.spec.error.type.UserCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.rsvp.error.spec.tlv.rsvp.error.spec.error.type.rsvp._case.RsvpError;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.rsvp.error.spec.tlv.rsvp.error.spec.error.type.rsvp._case.RsvpErrorBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.rsvp.error.spec.tlv.rsvp.error.spec.error.type.user._case.UserError;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.rsvp.error.spec.tlv.rsvp.error.spec.error.type.user._case.UserErrorBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.ErrorSpec;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public final class Stateful07RSVPErrorSpecTlvParser
implements TlvParser,
TlvSerializer {
    public static final int TYPE = 21;
    private static final int FLAGS_SIZE = 8;
    private static final int HEADER_LENGTH = 4;
    private static final int RSVP_ERROR_CLASS_NUM = 6;
    private static final int RSVP_IPV4_ERROR_CLASS_TYPE = 1;
    private static final int RSVP_IPV6_ERROR_CLASS_TYPE = 2;
    private static final int USER_ERROR_CLASS_NUM = 194;
    private static final int USER_ERROR_CLASS_TYPE = 1;
    private static final int IN_PLACE = 7;
    private static final int NOT_GUILTY = 6;

    @Override
    public RsvpErrorSpec parseTlv(ByteBuf buffer) throws PCEPDeserializerException {
        if (buffer == null) {
            return null;
        }
        buffer.readUnsignedShort();
        short classNum = buffer.readUnsignedByte();
        short classType = buffer.readUnsignedByte();
        ErrorType errorType = null;
        if (classNum == 6) {
            errorType = Stateful07RSVPErrorSpecTlvParser.parseRsvp(classType, buffer.slice());
        } else if (classNum == 194 && classType == 1) {
            errorType = Stateful07RSVPErrorSpecTlvParser.parseUserError(buffer.slice());
        }
        return new RsvpErrorSpecBuilder().setErrorType(errorType).build();
    }

    @Override
    public void serializeTlv(Tlv tlv, ByteBuf buffer) {
        Preconditions.checkArgument(tlv instanceof RsvpErrorSpec, "RSVPErrorSpecTlv is mandatory.");
        RsvpErrorSpec rsvp = (RsvpErrorSpec)tlv;
        ByteBuf body = Unpooled.buffer();
        if (rsvp.getErrorType().implementedInterface().equals(RsvpCase.class)) {
            RsvpCase r = (RsvpCase)rsvp.getErrorType();
            Stateful07RSVPErrorSpecTlvParser.serializeRsvp(r.getRsvpError(), body);
            TlvUtil.formatTlv(21, body, buffer);
        } else {
            UserCase u = (UserCase)rsvp.getErrorType();
            Stateful07RSVPErrorSpecTlvParser.serializerUserError(u.getUserError(), body);
            TlvUtil.formatTlv(21, body, buffer);
        }
    }

    private static UserCase parseUserError(ByteBuf buffer) {
        UserErrorBuilder error = new UserErrorBuilder().setEnterprise(new EnterpriseNumber(ByteBufUtils.readUint32(buffer)));
        error.setSubOrg(ByteBufUtils.readUint8(buffer));
        short errDescrLength = buffer.readUnsignedByte();
        error.setValue(ByteBufUtils.readUint16(buffer));
        error.setDescription(ByteArray.bytesToHRString(ByteArray.readBytes(buffer, errDescrLength)));
        return new UserCaseBuilder().setUserError(error.build()).build();
    }

    private static void serializerUserError(UserError ue, ByteBuf body) {
        String description = ue.getDescription();
        byte[] desc = description == null ? new byte[]{} : description.getBytes(StandardCharsets.UTF_8);
        ByteBuf userErrorBuf = Unpooled.buffer();
        EnterpriseNumber enterprise = ue.getEnterprise();
        Preconditions.checkArgument(enterprise != null, "EnterpriseNumber is mandatory");
        ByteBufUtils.write(userErrorBuf, enterprise.getValue());
        ByteBufUtils.writeOrZero(userErrorBuf, ue.getSubOrg());
        userErrorBuf.writeByte(desc.length);
        ByteBufUtils.writeMandatory(userErrorBuf, ue.getValue(), "Value");
        userErrorBuf.writeBytes(desc);
        userErrorBuf.writeZero(TlvUtil.getPadding(desc.length, 4));
        Stateful07RSVPErrorSpecTlvParser.formatRSVPObject(194, 1, userErrorBuf, body);
    }

    private static RsvpCase parseRsvp(int classType, ByteBuf buffer) {
        RsvpErrorBuilder builder = new RsvpErrorBuilder();
        if (classType == 1) {
            builder.setNode(new IpAddressNoZone(Ipv4Util.addressForByteBuf(buffer)));
        } else if (classType == 2) {
            builder.setNode(new IpAddressNoZone(Ipv6Util.addressForByteBuf(buffer)));
        }
        BitArray flags = BitArray.valueOf(buffer, 8);
        builder.setFlags(new ErrorSpec.Flags(flags.get(7), flags.get(6)));
        builder.setCode(ByteBufUtils.readUint8(buffer));
        builder.setValue(ByteBufUtils.readUint16(buffer));
        return new RsvpCaseBuilder().setRsvpError(builder.build()).build();
    }

    private static void serializeRsvp(RsvpError rsvp, ByteBuf body) {
        BitArray flags = new BitArray(8);
        flags.set(7, rsvp.getFlags().isInPlace());
        flags.set(6, rsvp.getFlags().isNotGuilty());
        IpAddressNoZone node = rsvp.getNode();
        Preconditions.checkArgument(node != null, "Node is mandatory.");
        ByteBuf rsvpObjBuf = Unpooled.buffer();
        int type = 0;
        if (node.getIpv4AddressNoZone() != null) {
            type = 1;
            Ipv4Util.writeIpv4Address(node.getIpv4AddressNoZone(), rsvpObjBuf);
        } else {
            type = 2;
            Ipv6Util.writeIpv6Address(node.getIpv6AddressNoZone(), rsvpObjBuf);
        }
        flags.toByteBuf(rsvpObjBuf);
        ByteBufUtils.writeMandatory(rsvpObjBuf, rsvp.getCode(), "Code");
        ByteBufUtils.writeMandatory(rsvpObjBuf, rsvp.getValue(), "Value");
        Stateful07RSVPErrorSpecTlvParser.formatRSVPObject(6, type, rsvpObjBuf, body);
    }

    private static void formatRSVPObject(int objClass, int type, ByteBuf body, ByteBuf out) {
        out.writeShort(body.writerIndex() + 4);
        out.writeByte(objClass);
        out.writeByte(type);
        out.writeBytes(body);
    }
}

