/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.lock.qual.GuardedBy;

final class PeerRecord {
    private final @GuardedBy(value={"this"}) Cache<Short, Short> pastIds;
    private @GuardedBy(value={"this"}) Short lastId;

    PeerRecord(long idLifetimeSeconds, Short lastId) {
        this.pastIds = CacheBuilder.newBuilder().expireAfterWrite(idLifetimeSeconds, TimeUnit.SECONDS).maximumSize(255L).build();
        this.lastId = lastId;
    }

    synchronized Short allocId() {
        short id;
        short s2 = id = this.lastId == null ? (short)0 : this.lastId;
        while (this.pastIds.getIfPresent(id) != null) {
            id = (short)((id + 1) % 255);
        }
        this.pastIds.put(id, id);
        this.lastId = id;
        return id;
    }
}

