/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.message;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.opendaylight.protocol.pcep.parser.util.Util;
import org.opendaylight.protocol.pcep.spi.AbstractMessageParser;
import org.opendaylight.protocol.pcep.spi.MessageUtil;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Pcmonrep;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.PcmonrepBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.metrics.MetricPce;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.Monitoring;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.response.monitoring.metrics.list.GeneralMetricsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.response.monitoring.metrics.list.GeneralMetricsListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.response.monitoring.metrics.list.SpecificMetricsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.response.monitoring.metrics.list.SpecificMetricsListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.response.monitoring.metrics.list.specific.metrics.list.SpecificMetrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.response.monitoring.metrics.list.specific.metrics.list.SpecificMetricsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcc.id.req.object.PccIdReq;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcmonrep.message.PcmonrepMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcmonrep.message.PcmonrepMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.Rp;

public class PCEPMonitoringReplyMessageParser
extends AbstractMessageParser {
    public static final int TYPE = 9;

    public PCEPMonitoringReplyMessageParser(ObjectRegistry registry) {
        super(registry);
    }

    @Override
    public void serializeMessage(Message message, ByteBuf buffer) {
        SpecificMetricsList sml;
        Preconditions.checkArgument(message instanceof Pcmonrep, "Wrong instance of Message. Passed instance of %s. Need Pcmonrep.", message.getClass());
        PcmonrepMessage monRepMsg = ((Pcmonrep)message).getPcmonrepMessage();
        Preconditions.checkArgument(monRepMsg.getMonitoring() != null, "MONITORING object is mandatory.");
        ByteBuf body = Unpooled.buffer();
        this.serializeObject(monRepMsg.getMonitoring(), body);
        this.serializeObject(monRepMsg.getPccIdReq(), body);
        if (monRepMsg.getMonitoringMetricsList() instanceof GeneralMetricsList) {
            GeneralMetricsList gml = (GeneralMetricsList)monRepMsg.getMonitoringMetricsList();
            if (gml.getMetricPce() != null) {
                for (MetricPce metricPce : gml.getMetricPce()) {
                    this.serializeMetricPce(metricPce, body);
                }
            }
        } else if (monRepMsg.getMonitoringMetricsList() instanceof SpecificMetricsList && (sml = (SpecificMetricsList)monRepMsg.getMonitoringMetricsList()).getSpecificMetrics() != null) {
            for (SpecificMetrics specificMetrics : sml.getSpecificMetrics()) {
                this.serializeObject(specificMetrics.getRp(), body);
                if (specificMetrics.getMetricPce() == null) continue;
                for (MetricPce metricPce : specificMetrics.getMetricPce()) {
                    this.serializeMetricPce(metricPce, body);
                }
            }
        }
        MessageUtil.formatMessage(9, body, buffer);
    }

    private void serializeMetricPce(MetricPce metricPce, ByteBuf buffer) {
        Preconditions.checkArgument(metricPce.getPceId() != null, "PCE-ID must be present.");
        this.serializeObject(metricPce.getPceId(), buffer);
        this.serializeObject(metricPce.getProcTime(), buffer);
        this.serializeObject(metricPce.getOverload(), buffer);
    }

    @Override
    protected Message validate(List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object> objects, List<Message> errors) throws PCEPDeserializerException {
        Preconditions.checkArgument(objects != null, "Passed list can't be null.");
        if (objects.isEmpty()) {
            throw new PCEPDeserializerException("Pcmonrep message cannot be empty.");
        }
        if (!(objects.get(0) instanceof Monitoring)) {
            errors.add(PCEPMonitoringReplyMessageParser.createErrorMsg(PCEPErrors.MONITORING_OBJECT_MISSING, Optional.empty()));
            return null;
        }
        PcmonrepMessageBuilder builder = new PcmonrepMessageBuilder().setMonitoring((Monitoring)objects.get(0));
        objects.remove(0);
        if (!objects.isEmpty() && objects.get(0) instanceof PccIdReq) {
            builder.setPccIdReq((PccIdReq)objects.get(0));
            objects.remove(0);
        }
        PCEPMonitoringReplyMessageParser.validateSpecificMetrics(objects, builder);
        if (!objects.isEmpty()) {
            throw new PCEPDeserializerException("Unprocessed Objects: " + objects);
        }
        return new PcmonrepBuilder().setPcmonrepMessage(builder.build()).build();
    }

    private static void validateSpecificMetrics(List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object> objects, PcmonrepMessageBuilder builder) throws PCEPDeserializerException {
        ArrayList<SpecificMetrics> specificMetrics = new ArrayList<SpecificMetrics>();
        while (!objects.isEmpty()) {
            SpecificMetricsBuilder smb = new SpecificMetricsBuilder();
            ArrayList<MetricPce> metricPceList = new ArrayList<MetricPce>();
            if (objects.get(0) instanceof Rp) {
                smb.setRp((Rp)objects.get(0));
                objects.remove(0);
            }
            while (!objects.isEmpty() && !(objects.get(0) instanceof Rp)) {
                metricPceList.add(Util.validateMonitoringMetrics(objects));
            }
            if (smb.getRp() != null) {
                smb.setMetricPce(metricPceList);
                specificMetrics.add(smb.build());
                continue;
            }
            if (metricPceList.isEmpty()) continue;
            builder.setMonitoringMetricsList(new GeneralMetricsListBuilder().setMetricPce(metricPceList).build());
        }
        if (!specificMetrics.isEmpty()) {
            builder.setMonitoringMetricsList(new SpecificMetricsListBuilder().setSpecificMetrics(specificMetrics).build());
        }
    }
}

