/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.message;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.opendaylight.protocol.pcep.spi.AbstractMessageParser;
import org.opendaylight.protocol.pcep.spi.MessageUtil;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.PcntfBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.PcntfMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.notification.object.CNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcntf.message.PcntfMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcntf.message.pcntf.message.Notifications;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcntf.message.pcntf.message.notifications.NotificationsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcntf.message.pcntf.message.notifications.Rps;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcntf.message.pcntf.message.notifications.RpsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.Rp;

public class PCEPNotificationMessageParser
extends AbstractMessageParser {
    public static final int TYPE = 5;

    public PCEPNotificationMessageParser(ObjectRegistry registry) {
        super(registry);
    }

    @Override
    public void serializeMessage(Message message, ByteBuf out) {
        Preconditions.checkArgument(message instanceof PcntfMessage, "Wrong instance of Message. Passed instance of %s. Need PcntfMessage.", message.getClass());
        ByteBuf buffer = Unpooled.buffer();
        for (Notifications n : ((PcntfMessage)message).getPcntfMessage().getNotifications()) {
            if (n.getRps() != null) {
                for (Rps rps : n.getRps()) {
                    this.serializeObject(rps.getRp(), buffer);
                }
            }
            Preconditions.checkArgument(n.getNotifications() != null && !n.getNotifications().isEmpty(), "Message must contain at least one notification object");
            for (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcntf.message.pcntf.message.notifications.Notifications not : n.getNotifications()) {
                this.serializeObject(not.getCNotification(), buffer);
            }
        }
        MessageUtil.formatMessage(5, buffer, out);
    }

    @Override
    protected Message validate(List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object> objects, List<Message> errors) throws PCEPDeserializerException {
        Notifications comObj;
        Preconditions.checkArgument(objects != null, "Passed list can't be null.");
        if (objects.isEmpty()) {
            throw new PCEPDeserializerException("Notification message cannot be empty.");
        }
        ArrayList<Notifications> compositeNotifications = new ArrayList<Notifications>();
        while (!objects.isEmpty() && (comObj = PCEPNotificationMessageParser.getValidNotificationComposite(objects, errors)) != null) {
            compositeNotifications.add(comObj);
        }
        if (compositeNotifications.isEmpty()) {
            throw new PCEPDeserializerException("Atleast one Notifications is mandatory.");
        }
        if (!objects.isEmpty()) {
            throw new PCEPDeserializerException("Unprocessed Objects: " + objects);
        }
        return new PcntfBuilder().setPcntfMessage(new PcntfMessageBuilder().setNotifications(compositeNotifications).build()).build();
    }

    private static Notifications getValidNotificationComposite(List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object> objects, List<Message> errors) {
        ArrayList<Rps> requestParameters = new ArrayList<Rps>();
        ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcntf.message.pcntf.message.notifications.Notifications> notifications = new ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcntf.message.pcntf.message.notifications.Notifications>();
        State state = State.INIT;
        while (!objects.isEmpty() && !state.equals((Object)State.END)) {
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object obj = objects.get(0);
            if ((state = PCEPNotificationMessageParser.insertObject(state, obj, errors, requestParameters, notifications)) == null) {
                return null;
            }
            if (state.equals((Object)State.END)) continue;
            objects.remove(0);
        }
        if (notifications.isEmpty()) {
            return null;
        }
        return new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcntf.message.pcntf.message.NotificationsBuilder().setNotifications(notifications).setRps(requestParameters).build();
    }

    private static State insertObject(State state, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object obj, List<Message> errors, List<Rps> requestParameters, List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcntf.message.pcntf.message.notifications.Notifications> notifications) {
        switch (state) {
            case INIT: {
                if (obj instanceof Rp) {
                    Rp rp = (Rp)obj;
                    if (rp.isProcessingRule().booleanValue()) {
                        errors.add(PCEPNotificationMessageParser.createErrorMsg(PCEPErrors.P_FLAG_NOT_SET, Optional.empty()));
                        return null;
                    }
                    requestParameters.add(new RpsBuilder().setRp(rp).build());
                    return State.INIT;
                }
            }
            case RP_IN: {
                if (obj instanceof CNotification) {
                    CNotification n = (CNotification)obj;
                    notifications.add(new NotificationsBuilder().setCNotification(n).build());
                    return State.RP_IN;
                }
            }
            case NOTIFICATION_IN: 
            case END: {
                return State.END;
            }
        }
        return state;
    }

    private static enum State {
        INIT,
        RP_IN,
        NOTIFICATION_IN,
        END;

    }
}

