/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.CommonObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.protocol.util.Ipv6Util;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcc.id.req.object.PccIdReq;

public abstract class AbstractPccIdReqObjectParser
extends CommonObjectParser
implements ObjectSerializer {
    private static final int CLASS = 20;

    public AbstractPccIdReqObjectParser(int objectType) {
        super(20, objectType);
    }

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof PccIdReq, "Wrong instance of PCEPObject. Passed %s. Needed PccIdReqObject.", object.getClass());
        PccIdReq pccIdReq = (PccIdReq)object;
        if (pccIdReq.getIpAddress().getIpv4AddressNoZone() != null) {
            ByteBuf body = Unpooled.buffer(4);
            Ipv4Util.writeIpv4Address(pccIdReq.getIpAddress().getIpv4AddressNoZone(), body);
            ObjectUtil.formatSubobject(this.getObjectType(), this.getObjectClass(), object.isProcessingRule(), object.isIgnore(), body, buffer);
        } else if (pccIdReq.getIpAddress().getIpv6AddressNoZone() != null) {
            ByteBuf body = Unpooled.buffer(16);
            Ipv6Util.writeIpv6Address(pccIdReq.getIpAddress().getIpv6AddressNoZone(), body);
            ObjectUtil.formatSubobject(this.getObjectType(), this.getObjectClass(), object.isProcessingRule(), object.isIgnore(), body, buffer);
        }
    }
}

