/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.CommonObjectParser;
import org.opendaylight.protocol.pcep.spi.EnterpriseSpecificInformationParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.objects.VendorInformationObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.objects.VendorInformationObjectBuilder;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public abstract class AbstractVendorInformationObjectParser
extends CommonObjectParser
implements ObjectSerializer,
EnterpriseSpecificInformationParser {
    public AbstractVendorInformationObjectParser(int objectClass, int objectType) {
        super(objectClass, objectType);
    }

    @Override
    public final Object parseObject(ObjectHeader header, ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument(buffer != null && buffer.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        return new VendorInformationObjectBuilder().setEnterpriseNumber(new EnterpriseNumber(this.getEnterpriseNumber())).setEnterpriseSpecificInformation(this.parseEnterpriseSpecificInformation(buffer)).build();
    }

    @Override
    public final void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof VendorInformationObject, "Wrong instance of PCEPObject. Passed %s. Needed VendorInformationObject.", object.getClass());
        ByteBuf body = Unpooled.buffer();
        ByteBufUtils.write(body, this.getEnterpriseNumber().getValue());
        this.serializeEnterpriseSpecificInformation(((VendorInformationObject)object).getEnterpriseSpecificInformation(), body);
        ObjectUtil.formatSubobject(1, 34, object.isProcessingRule(), object.isIgnore(), body, buffer);
    }
}

