/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.parser.object.AbstractEROWithSubobjectsParser;
import org.opendaylight.protocol.pcep.spi.EROSubobjectRegistry;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.Ero;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.EroBuilder;

public final class PCEPExplicitRouteObjectParser
extends AbstractEROWithSubobjectsParser {
    private static final int CLASS = 7;
    private static final int TYPE = 1;

    public PCEPExplicitRouteObjectParser(EROSubobjectRegistry subobjReg) {
        super(subobjReg, 7, 1);
    }

    @Override
    public Ero parseObject(ObjectHeader header, ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument(buffer != null, "Array of bytes is mandatory. Can't be null.");
        EroBuilder builder = new EroBuilder().setIgnore(header.isIgnore()).setProcessingRule(header.isProcessingRule()).setSubobject(this.parseSubobjects(buffer));
        return builder.build();
    }

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof Ero, "Wrong instance of PCEPObject. Passed %s. Needed EroObject.", object.getClass());
        Ero ero = (Ero)object;
        ByteBuf body = Unpooled.buffer();
        this.serializeSubobject(ero.getSubobject(), body);
        ObjectUtil.formatSubobject(1, 7, object.isProcessingRule(), object.isIgnore(), body, buffer);
    }
}

