/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.AbstractObjectWithTlvsParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.Monitoring;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.MonitoringBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.monitoring.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.monitoring.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.tlvs.VendorInformationTlv;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public class PCEPMonitoringObjectParser
extends AbstractObjectWithTlvsParser<TlvsBuilder> {
    private static final int CLASS = 19;
    private static final int TYPE = 1;
    private static final int FLAGS_SIZE = 24;
    private static final int RESERVED = 1;
    private static final int L_FLAG_POS = 23;
    private static final int G_FLAG_POS = 22;
    private static final int P_FLAG_POS = 21;
    private static final int C_FLAG_POS = 20;
    private static final int I_FLAG_POS = 19;

    public PCEPMonitoringObjectParser(TlvRegistry tlvReg, VendorInformationTlvRegistry viTlvReg) {
        super(tlvReg, viTlvReg, 19, 1);
    }

    @Override
    public Object parseObject(ObjectHeader header, ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument(buffer != null && buffer.isReadable(), "Array of bytes is mandatory. Cannot be null or empty.");
        buffer.readBytes(1);
        BitArray flagBits = BitArray.valueOf(buffer, 24);
        Monitoring.Flags flags = new Monitoring.Flags(flagBits.get(22), flagBits.get(19), flagBits.get(23), flagBits.get(20), flagBits.get(21));
        Uint32 monitoring = ByteBufUtils.readUint32(buffer);
        TlvsBuilder tbuilder = new TlvsBuilder();
        this.parseTlvs(tbuilder, buffer.slice());
        return new MonitoringBuilder().setFlags(flags).setMonitoringId(monitoring).setTlvs(tbuilder.build()).build();
    }

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof Monitoring, "Wrong instance of PCEPObject. Passed %s. Needed MonitoringObject.", object.getClass());
        Monitoring monitoring = (Monitoring)object;
        ByteBuf body = Unpooled.buffer();
        body.writeZero(1);
        Monitoring.Flags flags = monitoring.getFlags();
        BitArray flagBits = new BitArray(24);
        flagBits.set(19, flags.isIncomplete());
        flagBits.set(20, flags.isOverload());
        flagBits.set(21, flags.isProcessingTime());
        flagBits.set(22, flags.isGeneral());
        flagBits.set(23, flags.isLiveness());
        flagBits.toByteBuf(body);
        ByteBufUtils.writeOrZero(body, monitoring.getMonitoringId());
        this.serializeTlvs(monitoring.getTlvs(), body);
        ObjectUtil.formatSubobject(1, 19, object.isProcessingRule(), object.isIgnore(), body, buffer);
    }

    @Override
    protected void addVendorInformationTlvs(TlvsBuilder builder, List<VendorInformationTlv> tlvs) {
        if (!tlvs.isEmpty()) {
            builder.setVendorInformationTlv(tlvs);
        }
    }

    public void serializeTlvs(Tlvs tlvs, ByteBuf body) {
        if (tlvs != null) {
            this.serializeVendorInformationTlvs(tlvs.getVendorInformationTlv(), body);
        }
    }
}

