/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.AbstractObjectWithTlvsParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.notification.object.CNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.notification.object.CNotificationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.notification.object.c.notification.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.notification.object.c.notification.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.overload.duration.tlv.OverloadDuration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.tlvs.VendorInformationTlv;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public final class PCEPNotificationObjectParser
extends AbstractObjectWithTlvsParser<CNotificationBuilder> {
    private static final int CLASS = 12;
    private static final int TYPE = 1;
    private static final int NT_F_OFFSET = 2;

    public PCEPNotificationObjectParser(TlvRegistry tlvReg, VendorInformationTlvRegistry viTlvReg) {
        super(tlvReg, viTlvReg, 12, 1);
    }

    @Override
    public CNotification parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument(bytes != null && bytes.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        bytes.skipBytes(2);
        CNotificationBuilder builder = new CNotificationBuilder().setIgnore(header.isIgnore()).setProcessingRule(header.isProcessingRule()).setType(ByteBufUtils.readUint8(bytes)).setValue(ByteBufUtils.readUint8(bytes));
        this.parseTlvs(builder, bytes.slice());
        return builder.build();
    }

    @Override
    public void addTlv(CNotificationBuilder builder, Tlv tlv) {
        if (tlv instanceof OverloadDuration && builder.getType().toJava() == 2 && builder.getValue().toJava() == 1) {
            builder.setTlvs(new TlvsBuilder().setOverloadDuration((OverloadDuration)tlv).build());
        }
    }

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof CNotification, "Wrong instance of PCEPObject. Passed %s. Needed CNotificationObject.", object.getClass());
        CNotification notObj = (CNotification)object;
        ByteBuf body = Unpooled.buffer();
        body.writeZero(2);
        ByteBufUtils.writeMandatory(body, notObj.getType(), "Type");
        ByteBufUtils.writeMandatory(body, notObj.getValue(), "Value");
        this.serializeTlvs(notObj.getTlvs(), body);
        ObjectUtil.formatSubobject(1, 12, object.isProcessingRule(), object.isIgnore(), body, buffer);
    }

    public void serializeTlvs(Tlvs tlvs, ByteBuf body) {
        if (tlvs != null) {
            if (tlvs.getOverloadDuration() != null) {
                this.serializeTlv(tlvs.getOverloadDuration(), body);
            }
            this.serializeVendorInformationTlvs(tlvs.getVendorInformationTlv(), body);
        }
    }

    @Override
    protected void addVendorInformationTlvs(CNotificationBuilder builder, List<VendorInformationTlv> tlvs) {
        if (!tlvs.isEmpty()) {
            builder.setTlvs(new TlvsBuilder(builder.getTlvs()).setVendorInformationTlv(tlvs).build());
        }
    }
}

