/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.CommonObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object.ProcTime;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object.ProcTimeBuilder;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public class PCEPProcTimeObjectParser
extends CommonObjectParser
implements ObjectSerializer {
    private static final int CLASS = 26;
    private static final int TYPE = 1;
    private static final int RESERVED = 2;
    private static final int FLAGS = 16;
    private static final int COUNT_FIELDS = 5;
    private static final int BODY_SIZE = 38;
    private static final int E_FLAG_POSITION = 15;

    public PCEPProcTimeObjectParser() {
        super(26, 1);
    }

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof ProcTime, "Wrong instance of PCEPObject. Passed %s. Needed ProcTimeObject.", object.getClass());
        ProcTime procTime = (ProcTime)object;
        ByteBuf body = Unpooled.buffer(38);
        body.writeZero(2);
        BitArray flagBits = new BitArray(16);
        flagBits.set(15, procTime.isEstimated());
        flagBits.toByteBuf(body);
        ByteBufUtils.writeOrZero(body, procTime.getCurrentProcTime());
        ByteBufUtils.writeOrZero(body, procTime.getMinProcTime());
        ByteBufUtils.writeOrZero(body, procTime.getMaxProcTime());
        ByteBufUtils.writeOrZero(body, procTime.getAverageProcTime());
        ByteBufUtils.writeOrZero(body, procTime.getVarianceProcTime());
        ObjectUtil.formatSubobject(1, 26, object.isProcessingRule(), object.isIgnore(), body, buffer);
    }

    @Override
    public Object parseObject(ObjectHeader header, ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument(buffer != null && buffer.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        buffer.skipBytes(2);
        BitArray flagBits = BitArray.valueOf(buffer, 16);
        return new ProcTimeBuilder().setEstimated(flagBits.get(15)).setCurrentProcTime(ByteBufUtils.readUint32(buffer)).setMinProcTime(ByteBufUtils.readUint32(buffer)).setMaxProcTime(ByteBufUtils.readUint32(buffer)).setAverageProcTime(ByteBufUtils.readUint32(buffer)).setVarianceProcTime(ByteBufUtils.readUint32(buffer)).build();
    }
}

