/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.CommonObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.RequestId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.svec.object.Svec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.svec.object.SvecBuilder;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public final class PCEPSvecObjectParser
extends CommonObjectParser
implements ObjectSerializer {
    private static final int CLASS = 11;
    private static final int TYPE = 1;
    private static final int FLAGS_SIZE = 24;
    private static final int FLAGS_F_OFFSET = 1;
    private static final int P_FLAG_OFFSET = 19;
    private static final int D_FLAG_OFFSET = 20;
    private static final int S_FLAG_OFFSET = 21;
    private static final int N_FLAG_OFFSET = 22;
    private static final int L_FLAG_OFFSET = 23;
    private static final int MIN_SIZE = 4;

    public PCEPSvecObjectParser() {
        super(11, 1);
    }

    @Override
    public Svec parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument(bytes != null && bytes.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        if (bytes.readableBytes() < 4) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + bytes.readableBytes() + "; Expected: >=4.");
        }
        bytes.skipBytes(1);
        BitArray flags = BitArray.valueOf(bytes, 24);
        ArrayList<RequestId> requestIDs = new ArrayList<RequestId>();
        while (bytes.isReadable()) {
            requestIDs.add(new RequestId(ByteBufUtils.readUint32(bytes)));
        }
        if (requestIDs.isEmpty()) {
            throw new PCEPDeserializerException("Empty Svec Object - no request ids.");
        }
        return new SvecBuilder().setIgnore(header.isIgnore()).setProcessingRule(header.isProcessingRule()).setLinkDiverse(flags.get(23)).setNodeDiverse(flags.get(22)).setSrlgDiverse(flags.get(21)).setLinkDirectionDiverse(flags.get(20)).setPartialPathDiverse(flags.get(19)).setRequestsIds(requestIDs).build();
    }

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof Svec, "Wrong instance of PCEPObject. Passed %s. Needed SvecObject.", object.getClass());
        Svec svecObj = (Svec)object;
        ByteBuf body = Unpooled.buffer();
        body.writeZero(1);
        BitArray flags = new BitArray(24);
        flags.set(23, svecObj.isLinkDiverse());
        flags.set(22, svecObj.isNodeDiverse());
        flags.set(21, svecObj.isSrlgDiverse());
        flags.set(20, svecObj.isLinkDirectionDiverse());
        flags.set(19, svecObj.isPartialPathDiverse());
        flags.toByteBuf(body);
        List<RequestId> requestIDs = svecObj.getRequestsIds();
        assert (!requestIDs.isEmpty()) : "Empty Svec Object - no request ids.";
        for (RequestId requestId : requestIDs) {
            ByteBufUtils.write(body, requestId.getValue());
        }
        ObjectUtil.formatSubobject(1, 11, object.isProcessingRule(), object.isIgnore(), body, buffer);
    }
}

