/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object.bnc;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.parser.object.AbstractEROWithSubobjectsParser;
import org.opendaylight.protocol.pcep.parser.object.bnc.BNCUtil;
import org.opendaylight.protocol.pcep.spi.EROSubobjectRegistry;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.non.branch.node.object.NonBranchNodeList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.non.branch.node.object.NonBranchNodeListBuilder;

public final class NonBranchNodeListObjectParser
extends AbstractEROWithSubobjectsParser {
    private static final int CLASS = 31;
    private static final int TYPE = 2;

    public NonBranchNodeListObjectParser(EROSubobjectRegistry subobjReg) {
        super(subobjReg, 31, 2);
    }

    @Override
    public NonBranchNodeList parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument(bytes != null && bytes.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        NonBranchNodeListBuilder builder = new NonBranchNodeListBuilder();
        builder.setIgnore(header.isIgnore());
        builder.setProcessingRule(header.isProcessingRule());
        builder.setSubobject(BNCUtil.toBncSubobject(this.parseSubobjects(bytes)));
        return builder.build();
    }

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof NonBranchNodeList, "Wrong instance of PCEPObject. Passed %s. Needed NonBranchNodeList.", object.getClass());
        NonBranchNodeList nbnc = (NonBranchNodeList)object;
        ByteBuf body = Unpooled.buffer();
        this.serializeSubobject(BNCUtil.toIroSubject(nbnc.getSubobject()), body);
        ObjectUtil.formatSubobject(2, 31, object.isProcessingRule(), object.isIgnore(), body, buffer);
    }
}

