/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.subobject;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.EROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.EROSubobjectSerializer;
import org.opendaylight.protocol.pcep.spi.EROSubobjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.Ipv6Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.IpPrefixCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.IpPrefixCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.ip.prefix._case.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.ip.prefix._case.IpPrefixBuilder;

public class EROIpv6PrefixSubobjectParser
implements EROSubobjectParser,
EROSubobjectSerializer {
    public static final int TYPE = 2;
    private static final int PREFIX_F_OFFSET = 16;
    private static final int RESERVED = 1;
    private static final int CONTENT_LENGTH = 18;

    @Override
    public Subobject parseSubobject(ByteBuf buffer, boolean loose) throws PCEPDeserializerException {
        Preconditions.checkArgument(buffer != null && buffer.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        if (buffer.readableBytes() != 18) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + buffer.readableBytes() + ";");
        }
        short length = buffer.getUnsignedByte(16);
        IpPrefixBuilder prefix = new IpPrefixBuilder().setIpPrefix(new org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix(Ipv6Util.prefixForBytes(ByteArray.readBytes(buffer, 16), length)));
        SubobjectBuilder builder = new SubobjectBuilder().setLoose(loose).setSubobjectType(new IpPrefixCaseBuilder().setIpPrefix(prefix.build()).build());
        return builder.build();
    }

    @Override
    public void serializeSubobject(Subobject subobject, ByteBuf buffer) {
        Preconditions.checkArgument(subobject.getSubobjectType() instanceof IpPrefixCase, "Unknown subobject instance. Passed %s. Needed IpPrefixCase.", subobject.getSubobjectType().getClass());
        IpPrefix specObj = ((IpPrefixCase)subobject.getSubobjectType()).getIpPrefix();
        Ipv6Prefix ipv6prefix = specObj.getIpPrefix().getIpv6Prefix();
        Preconditions.checkArgument(ipv6prefix != null, "Ipv6Prefix is mandatory.");
        EROIpv6PrefixSubobjectParser.serializeSubobject(buffer, subobject, ipv6prefix);
    }

    static void serializeSubobject(ByteBuf buffer, Subobject subobject, Ipv6Prefix ipv6prefix) {
        ByteBuf body = Unpooled.buffer();
        Ipv6Util.writeIpv6Prefix(ipv6prefix, body);
        body.writeZero(1);
        EROSubobjectUtil.formatSubobject(2, subobject.isLoose(), body, buffer);
    }
}

