/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.subobject;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.EROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.EROSubobjectSerializer;
import org.opendaylight.protocol.pcep.spi.EROSubobjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.UnnumberedCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.UnnumberedCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.unnumbered._case.Unnumbered;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.unnumbered._case.UnnumberedBuilder;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public class EROUnnumberedInterfaceSubobjectParser
implements EROSubobjectParser,
EROSubobjectSerializer {
    public static final int TYPE = 4;
    private static final int RESERVED = 2;
    private static final int CONTENT_LENGTH = 10;

    @Override
    public Subobject parseSubobject(ByteBuf buffer, boolean loose) throws PCEPDeserializerException {
        Preconditions.checkArgument(buffer != null && buffer.isReadable(), "Array of bytes is mandatory. Cannot be null or empty.");
        if (buffer.readableBytes() != 10) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + buffer.readableBytes() + "; Expected: 10.");
        }
        buffer.skipBytes(2);
        return new SubobjectBuilder().setLoose(loose).setSubobjectType(new UnnumberedCaseBuilder().setUnnumbered(new UnnumberedBuilder().setRouterId(ByteBufUtils.readUint32(buffer)).setInterfaceId(ByteBufUtils.readUint32(buffer)).build()).build()).build();
    }

    @Override
    public void serializeSubobject(Subobject subobject, ByteBuf buffer) {
        Preconditions.checkArgument(subobject.getSubobjectType() instanceof UnnumberedCase, "Unknown subobject instance. Passed %s. Needed UnnumberedCase.", subobject.getSubobjectType().getClass());
        Unnumbered specObj = ((UnnumberedCase)subobject.getSubobjectType()).getUnnumbered();
        ByteBuf body = Unpooled.buffer(10);
        body.writeZero(2);
        ByteBufUtils.writeMandatory(body, specObj.getRouterId(), "RouterId");
        ByteBufUtils.writeMandatory(body, specObj.getInterfaceId(), "InterfaceId");
        EROSubobjectUtil.formatSubobject(4, subobject.isLoose(), body, buffer);
    }
}

