/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.subobject;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.LabelParser;
import org.opendaylight.protocol.pcep.spi.LabelSerializer;
import org.opendaylight.protocol.pcep.spi.LabelUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.LabelType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.WavebandSwitchingLabelCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.WavebandSwitchingLabelCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.waveband.switching.label._case.WavebandSwitchingLabel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.waveband.switching.label._case.WavebandSwitchingLabelBuilder;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public class WavebandSwitchingLabelParser
implements LabelParser,
LabelSerializer {
    public static final int CTYPE = 3;
    private static final int WAVEB_F_LENGTH = 4;
    private static final int START_F_LENGTH = 4;
    private static final int END_F_LENGTH = 4;
    private static final int CONTENT_LENGTH = 12;

    @Override
    public LabelType parseLabel(ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument(buffer != null && buffer.isReadable(), "Array of bytes is mandatory. Cannot be null or empty.");
        if (buffer.readableBytes() != 12) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + buffer.readableBytes() + "; Expected: 12.");
        }
        return new WavebandSwitchingLabelCaseBuilder().setWavebandSwitchingLabel(new WavebandSwitchingLabelBuilder().setWavebandId(ByteBufUtils.readUint32(buffer)).setStartLabel(ByteBufUtils.readUint32(buffer)).setEndLabel(ByteBufUtils.readUint32(buffer)).build()).build();
    }

    @Override
    public void serializeLabel(boolean unidirectional, boolean global, LabelType subobject, ByteBuf buffer) {
        Preconditions.checkArgument(subobject instanceof WavebandSwitchingLabelCase, "Unknown Label Subobject instance. Passed {}. Needed WavebandSwitchingLabelCase.", subobject.getClass());
        WavebandSwitchingLabel obj = ((WavebandSwitchingLabelCase)subobject).getWavebandSwitchingLabel();
        ByteBuf body = Unpooled.buffer(12);
        ByteBufUtils.writeMandatory(body, obj.getWavebandId(), "WavebandId");
        ByteBufUtils.writeMandatory(body, obj.getStartLabel(), "StartLabel");
        ByteBufUtils.writeMandatory(body, obj.getEndLabel(), "EndLabel");
        LabelUtil.formatLabel(3, unidirectional, global, body, buffer);
    }
}

