/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.subobject;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.parser.subobject.XROIpv6PrefixSubobjectParser;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.XROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.XROSubobjectSerializer;
import org.opendaylight.protocol.pcep.spi.XROSubobjectUtil;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.xro.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.xro.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.ExcludeRouteSubobjects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.IpPrefixCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.IpPrefixCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.ip.prefix._case.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.ip.prefix._case.IpPrefixBuilder;

public class XROIpv4PrefixSubobjectParser
implements XROSubobjectParser,
XROSubobjectSerializer {
    public static final int TYPE = 1;
    private static final int PREFIX_F_LENGTH = 1;
    private static final int PREFIX4_F_OFFSET = 4;
    private static final int CONTENT4_LENGTH = 6;

    @Override
    public Subobject parseSubobject(ByteBuf buffer, boolean mandatory) throws PCEPDeserializerException {
        Preconditions.checkArgument(buffer != null && buffer.isReadable(), "Array of bytes is mandatory. Cannot be null or empty.");
        if (buffer.readableBytes() != 6) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + buffer.readableBytes() + ";");
        }
        short length = buffer.getUnsignedByte(4);
        IpPrefixBuilder prefix = new IpPrefixBuilder().setIpPrefix(new org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix(Ipv4Util.prefixForBytes(ByteArray.readBytes(buffer, 4), length)));
        buffer.skipBytes(1);
        return new SubobjectBuilder().setMandatory(mandatory).setSubobjectType(new IpPrefixCaseBuilder().setIpPrefix(prefix.build()).build()).setAttribute(ExcludeRouteSubobjects.Attribute.forValue(buffer.readUnsignedByte())).build();
    }

    @Override
    public void serializeSubobject(Subobject subobject, ByteBuf buffer) {
        Preconditions.checkArgument(subobject.getSubobjectType() instanceof IpPrefixCase, "Unknown subobject instance. Passed %s. Needed IpPrefixCase.", subobject.getSubobjectType().getClass());
        IpPrefix specObj = ((IpPrefixCase)subobject.getSubobjectType()).getIpPrefix();
        org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix prefix = specObj.getIpPrefix();
        Ipv6Prefix ipv6Prefix = prefix.getIpv6Prefix();
        if (ipv6Prefix != null) {
            XROIpv6PrefixSubobjectParser.serializeSubobject(buffer, subobject, ipv6Prefix);
            return;
        }
        Ipv4Prefix ipv4Prefix = prefix.getIpv4Prefix();
        Preconditions.checkArgument(ipv4Prefix != null, "Ipv4Prefix is mandatory.");
        ByteBuf body = Unpooled.buffer(6);
        Ipv4Util.writeIpv4Prefix(ipv4Prefix, body);
        ExcludeRouteSubobjects.Attribute attribute = subobject.getAttribute();
        Preconditions.checkArgument(attribute != null, "Attribute is mandatory.");
        body.writeByte(attribute.getIntValue());
        XROSubobjectUtil.formatSubobject(1, subobject.isMandatory(), body, buffer);
    }
}

