/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.subobject;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.parser.subobject.XROPathKey128SubobjectParser;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.XROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.XROSubobjectSerializer;
import org.opendaylight.protocol.pcep.spi.XROSubobjectUtil;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.xro.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.xro.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PathKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PceId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.PathKeyCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.PathKeyCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.path.key._case.PathKeyBuilder;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public class XROPathKey32SubobjectParser
implements XROSubobjectParser,
XROSubobjectSerializer {
    public static final int TYPE = 64;
    private static final int PCE_ID_F_LENGTH = 4;
    private static final int CONTENT_LENGTH = 6;

    @Override
    public Subobject parseSubobject(ByteBuf buffer, boolean mandatory) throws PCEPDeserializerException {
        Preconditions.checkArgument(buffer != null && buffer.isReadable(), "Array of bytes is mandatory. Cannot be null or empty.");
        if (buffer.readableBytes() != 6) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + buffer.readableBytes() + "; Expected: >6.");
        }
        return new SubobjectBuilder().setMandatory(mandatory).setSubobjectType(new PathKeyCaseBuilder().setPathKey(new PathKeyBuilder().setPathKey(new PathKey(ByteBufUtils.readUint16(buffer))).setPceId(new PceId(ByteArray.readBytes(buffer, 4))).build()).build()).build();
    }

    @Override
    public void serializeSubobject(Subobject subobject, ByteBuf buffer) {
        PathKey pathKey;
        Preconditions.checkArgument(subobject.getSubobjectType() instanceof PathKeyCase, "Unknown subobject instance. Passed %s. Needed PathKey.", subobject.getSubobjectType().getClass());
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.path.key._case.PathKey pk = ((PathKeyCase)subobject.getSubobjectType()).getPathKey();
        ByteBuf body = Unpooled.buffer();
        Preconditions.checkArgument(pk.getPceId() != null, "PceId is mandatory.");
        byte[] pceId = pk.getPceId().getValue();
        if (pceId.length == 16) {
            XROPathKey128SubobjectParser.serializeSubobject(subobject, buffer);
        }
        Preconditions.checkArgument((pathKey = pk.getPathKey()) != null, "PathKey is mandatory.");
        ByteBufUtils.write(body, pathKey.getValue());
        Preconditions.checkArgument(pceId.length == 4, "PceId 32 Bit required.");
        body.writeBytes(pceId);
        XROSubobjectUtil.formatSubobject(64, subobject.isMandatory(), body, buffer);
    }
}

