/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.tlv;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.EnterpriseSpecificInformationParser;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.EnterpriseSpecificInformation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.tlvs.VendorInformationTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.tlvs.VendorInformationTlvBuilder;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public abstract class AbstractVendorInformationTlvParser
implements TlvSerializer,
TlvParser,
EnterpriseSpecificInformationParser {
    @Override
    public final void serializeTlv(Tlv tlv, ByteBuf buffer) {
        Preconditions.checkArgument(tlv instanceof VendorInformationTlv, "Vendor Specific Tlv is mandatory.");
        VendorInformationTlv viTlv = (VendorInformationTlv)tlv;
        ByteBuf body = Unpooled.buffer();
        ByteBufUtils.write(body, this.getEnterpriseNumber().getValue());
        this.serializeEnterpriseSpecificInformation(viTlv.getEnterpriseSpecificInformation(), body);
        TlvUtil.formatTlv(7, body, buffer);
    }

    @Override
    public final VendorInformationTlv parseTlv(ByteBuf buffer) throws PCEPDeserializerException {
        EnterpriseSpecificInformation esInformation;
        if (buffer == null) {
            return null;
        }
        VendorInformationTlvBuilder viTlvBuider = new VendorInformationTlvBuilder().setEnterpriseNumber(this.getEnterpriseNumber());
        if (buffer.isReadable() && (esInformation = this.parseEnterpriseSpecificInformation(buffer.slice())) != null) {
            viTlvBuider.setEnterpriseSpecificInformation(esInformation);
        }
        return viTlvBuider.build();
    }
}

