/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.tlv;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.order.tlv.Order;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.order.tlv.OrderBuilder;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public class OrderTlvParser
implements TlvParser,
TlvSerializer {
    public static final int TYPE = 5;

    @Override
    public Order parseTlv(ByteBuf buffer) throws PCEPDeserializerException {
        if (buffer == null) {
            return null;
        }
        return new OrderBuilder().setDelete(ByteBufUtils.readUint32(buffer)).setSetup(ByteBufUtils.readUint32(buffer)).build();
    }

    @Override
    public void serializeTlv(Tlv tlv, ByteBuf buffer) {
        Preconditions.checkArgument(tlv instanceof Order, "OrderTlv is mandatory.");
        Order otlv = (Order)tlv;
        ByteBuf body = Unpooled.buffer();
        ByteBufUtils.writeOrZero(body, otlv.getDelete());
        ByteBufUtils.writeOrZero(body, otlv.getSetup());
        TlvUtil.formatTlv(5, body, buffer);
    }
}

