/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.tlv;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.overload.duration.tlv.OverloadDuration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.overload.duration.tlv.OverloadDurationBuilder;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public class OverloadedDurationTlvParser
implements TlvParser,
TlvSerializer {
    public static final int TYPE = 2;

    @Override
    public OverloadDuration parseTlv(ByteBuf buffer) throws PCEPDeserializerException {
        if (buffer == null) {
            return null;
        }
        return new OverloadDurationBuilder().setDuration(ByteBufUtils.readUint32(buffer)).build();
    }

    @Override
    public void serializeTlv(Tlv tlv, ByteBuf buffer) {
        Preconditions.checkArgument(tlv instanceof OverloadDuration, "OverloadedTlv is mandatory.");
        ByteBuf body = Unpooled.buffer();
        ByteBufUtils.writeOrZero(body, ((OverloadDuration)tlv).getDuration());
        TlvUtil.formatTlv(2, body, buffer);
    }
}

