/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.pcc.mock;

import io.netty.util.Timeout;
import org.opendaylight.protocol.pcep.pcc.mock.api.LspType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.pcrpt.message.pcrpt.message.reports.Path;

final class PCCTunnel {
    private final byte[] pathName;
    private final LspType type;
    private int delegationHolder;
    private Path lspState;
    private Timeout redelegationTimeout;
    private Timeout stateTimeout;

    PCCTunnel(byte[] pathName, int delegationHolder, LspType type, Path lspState) {
        this.pathName = (byte[])(pathName != null ? (byte[])pathName.clone() : null);
        this.delegationHolder = delegationHolder;
        this.type = type;
        this.lspState = lspState;
    }

    public byte[] getPathName() {
        return this.pathName;
    }

    public int getDelegationHolder() {
        return this.delegationHolder;
    }

    public void setDelegationHolder(int delegationHolder) {
        this.delegationHolder = delegationHolder;
    }

    public LspType getType() {
        return this.type;
    }

    public Path getLspState() {
        return this.lspState;
    }

    public void setLspState(Path lspState) {
        this.lspState = lspState;
    }

    public void setRedelegationTimeout(Timeout redelegationTimeout) {
        this.redelegationTimeout = redelegationTimeout;
    }

    public void setStateTimeout(Timeout stateTimeout) {
        this.stateTimeout = stateTimeout;
    }

    public void cancelTimeouts() {
        if (this.redelegationTimeout != null) {
            this.redelegationTimeout.cancel();
        }
        if (this.stateTimeout != null) {
            this.stateTimeout.cancel();
        }
    }
}

