/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.pcc.mock;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.opendaylight.protocol.pcep.pcc.mock.PCCSyncOptimization;
import org.opendaylight.protocol.pcep.pcc.mock.PCCTunnel;
import org.opendaylight.protocol.pcep.pcc.mock.PCCTunnelBuilder;
import org.opendaylight.protocol.pcep.pcc.mock.TimerHandler;
import org.opendaylight.protocol.pcep.pcc.mock.api.LspType;
import org.opendaylight.protocol.pcep.pcc.mock.api.PCCSession;
import org.opendaylight.protocol.pcep.pcc.mock.api.PCCTunnelManager;
import org.opendaylight.protocol.pcep.pcc.mock.spi.MsgBuilderUtil;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated.rev181109.Lsp1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated.rev181109.Lsp1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated.rev181109.Srp1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated.rev181109.Srp1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated.rev181109.pcinitiate.message.pcinitiate.message.Requests;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.OperationalStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.Pcrpt;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.PlspId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.SrpIdNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.lsp.object.Lsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.lsp.object.LspBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.lsp.object.lsp.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.pcrpt.message.pcrpt.message.reports.Path;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.pcrpt.message.pcrpt.message.reports.PathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.pcupd.message.pcupd.message.Updates;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.srp.object.Srp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.srp.object.SrpBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.IpPrefixCase;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;

public final class PCCTunnelManagerImpl
implements PCCTunnelManager {
    private static final Optional<Srp> NO_SRP = Optional.empty();
    private final @GuardedBy(value={"this"}) Map<Integer, PCCSession> sessions = new HashMap<Integer, PCCSession>();
    private final AtomicLong plspIDsCounter;
    private final String address;
    private final Timer timer;
    private final int redelegationTimeout;
    private final int stateTimeout;
    private final int lspsCount;
    private final Optional<TimerHandler> timerHandler;
    private final @GuardedBy(value={"this"}) Map<PlspId, PCCTunnel> tunnels = new HashMap<PlspId, PCCTunnel>();
    private PCCSyncOptimization syncOptimization;

    public PCCTunnelManagerImpl(int lspsCount, InetAddress address, int redelegationTimeout, int stateTimeout, Timer timer, Optional<TimerHandler> timerHandler) {
        Preconditions.checkArgument(lspsCount >= 0);
        this.redelegationTimeout = redelegationTimeout;
        this.stateTimeout = stateTimeout;
        this.plspIDsCounter = new AtomicLong(lspsCount);
        this.address = InetAddresses.toAddrString(Objects.requireNonNull(address));
        this.timer = Objects.requireNonNull(timer);
        this.timerHandler = timerHandler;
        this.lspsCount = lspsCount;
    }

    protected void reportToAll(Updates update, PCCSession session) {
        PlspId plspId = update.getLsp().getPlspId();
        PCCTunnel tunnel = this.tunnels.get(plspId);
        Uint32 srpId = update.getSrp().getOperationId().getValue();
        if (tunnel != null) {
            if (PCCTunnelManagerImpl.hasDelegation(tunnel, session)) {
                Srp srp = MsgBuilderUtil.createSrp(srpId);
                Path path = MsgBuilderUtil.updToRptPath(update.getPath());
                List<Subobject> subobjects = update.getPath().getEro().getSubobject();
                Lsp lsp = update.getLsp();
                this.sendToAll(tunnel, plspId, subobjects, srp, path, lsp);
                tunnel.setLspState(path);
            } else {
                session.sendError(MsgBuilderUtil.createErrorMsg(PCEPErrors.UPDATE_REQ_FOR_NON_LSP, srpId));
            }
        } else {
            session.sendError(MsgBuilderUtil.createErrorMsg(PCEPErrors.UNKNOWN_PLSP_ID, srpId));
        }
    }

    private void returnDelegation(Updates update, PCCSession session) {
        PlspId plspId = update.getLsp().getPlspId();
        PCCTunnel tunnel = this.tunnels.get(plspId);
        Uint32 srpId = update.getSrp().getOperationId().getValue();
        if (tunnel != null) {
            if (PCCTunnelManagerImpl.hasDelegation(tunnel, session)) {
                Tlvs tlvs = this.buildTlvs(tunnel, plspId.getValue(), Optional.empty());
                Pcrpt pcrtp = MsgBuilderUtil.createPcRtpMessage(new LspBuilder(update.getLsp()).setSync(true).setOperational(OperationalStatus.Up).setDelegate(false).setTlvs(tlvs).build(), Optional.of(MsgBuilderUtil.createSrp(srpId)), tunnel.getLspState());
                session.sendReport(pcrtp);
                this.startStateTimeout(tunnel, plspId);
                if (tunnel.getType() == LspType.PCC_LSP) {
                    this.startRedelegationTimer(tunnel, plspId, session);
                } else {
                    this.setDelegation(plspId, null);
                }
            } else {
                session.sendError(MsgBuilderUtil.createErrorMsg(PCEPErrors.UPDATE_REQ_FOR_NON_LSP, srpId));
            }
        } else {
            session.sendError(MsgBuilderUtil.createErrorMsg(PCEPErrors.UNKNOWN_PLSP_ID, srpId));
        }
    }

    protected void takeDelegation(Requests request, PCCSession session) {
        PlspId plspId = request.getLsp().getPlspId();
        PCCTunnel tunnel = this.tunnels.get(plspId);
        Uint32 srpId = request.getSrp().getOperationId().getValue();
        if (tunnel != null) {
            if (tunnel.getType() == LspType.PCE_LSP && (tunnel.getDelegationHolder() == -1 || tunnel.getDelegationHolder() == session.getId())) {
                tunnel.cancelTimeouts();
                this.setDelegation(plspId, session);
                Tlvs tlvs = this.buildTlvs(tunnel, plspId.getValue(), Optional.empty());
                session.sendReport(MsgBuilderUtil.createPcRtpMessage(new LspBuilder(request.getLsp()).setSync(true).setOperational(OperationalStatus.Up).setDelegate(true).setTlvs(tlvs).build(), Optional.of(MsgBuilderUtil.createSrp(srpId)), tunnel.getLspState()));
            } else {
                session.sendError(MsgBuilderUtil.createErrorMsg(PCEPErrors.LSP_NOT_PCE_INITIATED, srpId));
            }
        } else {
            session.sendError(MsgBuilderUtil.createErrorMsg(PCEPErrors.UNKNOWN_PLSP_ID, srpId));
        }
    }

    @Override
    public synchronized void onSessionUp(PCCSession session) {
        this.syncOptimization = new PCCSyncOptimization(session);
        this.lazyTunnelInicialization();
        if (!this.sessions.containsKey(session.getId()) && session.getId() == 0) {
            for (PlspId plspId : this.tunnels.keySet()) {
                this.setDelegation(plspId, session);
            }
        }
        this.sessions.put(session.getId(), session);
        if (!this.syncOptimization.isTriggeredInitSyncEnabled()) {
            this.lspReport(session);
        }
    }

    @Override
    public synchronized void onSessionDown(PCCSession session) {
        for (Map.Entry<PlspId, PCCTunnel> entry : this.tunnels.entrySet()) {
            PCCTunnel tunnel = entry.getValue();
            PlspId plspId = entry.getKey();
            if (!PCCTunnelManagerImpl.hasDelegation(tunnel, session)) continue;
            this.startStateTimeout(tunnel, entry.getKey());
            this.startRedelegationTimer(tunnel, plspId, session);
        }
    }

    protected void addTunnel(Requests request, PCCSession session) {
        PlspId plspId = new PlspId(Uint32.valueOf(this.plspIDsCounter.incrementAndGet()));
        PCCTunnel tunnel = new PCCTunnel(request.getLsp().getTlvs().getSymbolicPathName().getPathName().getValue(), session.getId(), LspType.PCE_LSP, MsgBuilderUtil.reqToRptPath(request));
        this.sendToAll(tunnel, plspId, request.getEro().getSubobject(), MsgBuilderUtil.createSrp(request.getSrp().getOperationId().getValue()), tunnel.getLspState(), new LspBuilder(request.getLsp()).addAugmentation(Lsp1.class, new Lsp1Builder().setCreate(true).build()).build());
        this.tunnels.put(plspId, tunnel);
    }

    protected void removeTunnel(Requests request, PCCSession session) {
        PlspId plspId = request.getLsp().getPlspId();
        PCCTunnel tunnel = this.tunnels.get(plspId);
        Uint32 srpId = request.getSrp().getOperationId().getValue();
        if (tunnel != null) {
            if (tunnel.getType() == LspType.PCE_LSP) {
                if (PCCTunnelManagerImpl.hasDelegation(tunnel, session)) {
                    this.tunnels.remove(plspId);
                    this.sendToAll(tunnel, plspId, tunnel.getLspState().getEro().getSubobject(), new SrpBuilder(request.getSrp()).addAugmentation(Srp1.class, new Srp1Builder().setRemove(true).build()).build(), MsgBuilderUtil.reqToRptPath(request), request.getLsp());
                } else {
                    session.sendError(MsgBuilderUtil.createErrorMsg(PCEPErrors.UPDATE_REQ_FOR_NON_LSP, srpId));
                }
            } else {
                session.sendError(MsgBuilderUtil.createErrorMsg(PCEPErrors.LSP_NOT_PCE_INITIATED, srpId));
            }
        } else {
            session.sendError(MsgBuilderUtil.createErrorMsg(PCEPErrors.UNKNOWN_PLSP_ID, srpId));
        }
    }

    @Override
    public void onMessagePcupd(Updates update, PCCSession session) {
        Lsp lsp = update.getLsp();
        if (this.isInitialSyncTriggered(lsp)) {
            this.lspReport(session);
            if (this.timerHandler.isPresent()) {
                this.timerHandler.get().createDisconnectTask();
            }
        } else if (this.isReSyncTriggered(lsp)) {
            this.handledDbTriggeredResync(update, session);
        } else if (lsp.isDelegate() != null && lsp.isDelegate().booleanValue()) {
            this.reportToAll(update, session);
        } else {
            this.returnDelegation(update, session);
        }
    }

    @Override
    public void onMessagePcInitiate(Requests request, PCCSession session) {
        if (request.getSrp().augmentation(Srp1.class) != null && request.getSrp().augmentation(Srp1.class).isRemove().booleanValue()) {
            this.removeTunnel(request, session);
        } else if (request.getLsp().isDelegate() != null && request.getLsp().isDelegate().booleanValue() && request.getEndpointsObj() == null) {
            this.takeDelegation(request, session);
        } else {
            this.addTunnel(request, session);
        }
    }

    private Tlvs buildTlvs(PCCTunnel tunnel, Uint32 plspId, Optional<List<Subobject>> subobjectsList) {
        List<Subobject> subObject = subobjectsList.isPresent() ? subobjectsList.get() : tunnel.getLspState().getEro().getSubobject();
        String destinationAddress = PCCTunnelManagerImpl.getDestinationAddress(subObject, this.address);
        return MsgBuilderUtil.createLspTlvs(plspId, true, destinationAddress, this.address, this.address, Optional.of(tunnel.getPathName()), this.syncOptimization.incrementLspDBVersion());
    }

    private synchronized void lazyTunnelInicialization() {
        if (this.tunnels.isEmpty()) {
            Uint64 dbV = this.syncOptimization.getLocalLspDbVersionValue();
            if (dbV != null && this.syncOptimization.isSyncAvoidanceEnabled() && !dbV.equals(Uint64.ONE)) {
                this.tunnels.putAll(PCCTunnelBuilder.createTunnels(this.address, dbV.intValue()));
            } else {
                this.tunnels.putAll(PCCTunnelBuilder.createTunnels(this.address, this.lspsCount));
            }
        }
    }

    private boolean isReSyncTriggered(Lsp lsp) {
        return this.syncOptimization.isTriggeredReSyncEnabled() && lsp.isSync() != false;
    }

    private boolean isInitialSyncTriggered(Lsp lsp) {
        return lsp.getPlspId().getValue().toJava() == 0L && lsp.isSync() != false && this.syncOptimization.isTriggeredInitSyncEnabled();
    }

    private void handledDbTriggeredResync(Updates update, PCCSession session) {
        this.syncOptimization.setResynchronizingState(Boolean.TRUE);
        SrpIdNumber operationId = update.getSrp().getOperationId();
        if (update.getLsp().getPlspId().getValue().toJava() == 0L) {
            this.reportAllKnownLsp(Optional.of(operationId), session);
        } else {
            this.reportLsp(update.getLsp().getPlspId(), operationId, session);
        }
        this.sendEndOfSynchronization(session, Optional.of(operationId));
        this.syncOptimization.setResynchronizingState(Boolean.FALSE);
    }

    private void lspReport(PCCSession session) {
        if (!this.tunnels.isEmpty()) {
            if (!this.syncOptimization.isSyncAvoidanceEnabled()) {
                this.reportAllKnownLsp(session);
                this.sendEndOfSynchronization(session);
            } else if (!this.syncOptimization.doesLspDbMatch()) {
                if (this.syncOptimization.isDeltaSyncEnabled()) {
                    this.reportMissedLsp(session);
                    this.sendEndOfSynchronization(session);
                } else {
                    this.reportAllKnownLsp(session);
                    this.sendEndOfSynchronization(session);
                }
            }
        }
    }

    private void reportMissedLsp(PCCSession session) {
        for (long missedLsp = this.syncOptimization.getRemoteLspDbVersionValue().longValue() + 1L; missedLsp <= this.syncOptimization.getLocalLspDbVersionValue().longValue(); ++missedLsp) {
            Uint32 missed = Uint32.valueOf(missedLsp);
            PlspId plspId = new PlspId(missed);
            PCCTunnel tunnel = this.tunnels.get(plspId);
            this.createLspAndSendReport(missed, tunnel, session, Optional.empty(), NO_SRP);
        }
    }

    private void createLspAndSendReport(Uint32 plspId, PCCTunnel tunnel, PCCSession session, Optional<Boolean> isSync, Optional<Srp> srp) {
        boolean delegation = PCCTunnelManagerImpl.hasDelegation(tunnel, session);
        if (delegation) {
            tunnel.cancelTimeouts();
        }
        String destinationAddress = PCCTunnelManagerImpl.getDestinationAddress(tunnel.getLspState().getEro().getSubobject(), this.address);
        Tlvs tlvs = MsgBuilderUtil.createLspTlvs(plspId, true, destinationAddress, this.address, this.address, Optional.of(tunnel.getPathName()), this.syncOptimization.incrementLspDBVersion());
        boolean sync = isSync.isPresent() ? isSync.get().booleanValue() : this.syncOptimization.isSyncNeedIt();
        Lsp lsp = MsgBuilderUtil.createLsp(plspId, sync, Optional.ofNullable(tlvs), delegation, false);
        Pcrpt pcrtp = MsgBuilderUtil.createPcRtpMessage(lsp, srp, tunnel.getLspState());
        session.sendReport(pcrtp);
    }

    private void sendEndOfSynchronization(PCCSession session) {
        this.sendEndOfSynchronization(session, Optional.empty());
    }

    private void sendEndOfSynchronization(PCCSession session, Optional<SrpIdNumber> operationId) {
        Srp srp = null;
        if (operationId.isPresent()) {
            srp = new SrpBuilder().setOperationId(operationId.get()).build();
        }
        Optional<Tlvs> tlv = Optional.empty();
        if (this.syncOptimization.isSyncAvoidanceEnabled()) {
            tlv = MsgBuilderUtil.createLspTlvsEndofSync(this.syncOptimization.incrementLspDBVersion().get());
        }
        Pcrpt pcrtp = MsgBuilderUtil.createPcRtpMessage(MsgBuilderUtil.createLsp(Uint32.ZERO, false, tlv, true, false), Optional.ofNullable(srp), MsgBuilderUtil.createPath(Collections.emptyList()));
        session.sendReport(pcrtp);
    }

    private void reportAllKnownLsp(PCCSession session) {
        this.reportAllKnownLsp(Optional.empty(), session);
    }

    private void reportAllKnownLsp(Optional<SrpIdNumber> operationId, PCCSession session) {
        Srp srp = null;
        if (operationId.isPresent()) {
            srp = new SrpBuilder().setOperationId(operationId.get()).build();
        }
        for (Map.Entry<PlspId, PCCTunnel> entry : this.tunnels.entrySet()) {
            PCCTunnel tunnel = entry.getValue();
            Uint32 plspId = entry.getKey().getValue();
            this.createLspAndSendReport(plspId, tunnel, session, Optional.empty(), Optional.ofNullable(srp));
        }
    }

    private void reportLsp(PlspId plspId, SrpIdNumber operationId, PCCSession session) {
        PCCTunnel tunnel = this.tunnels.get(plspId);
        if (tunnel == null) {
            return;
        }
        Srp srp = new SrpBuilder().setOperationId(operationId).build();
        this.createLspAndSendReport(plspId.getValue(), tunnel, session, Optional.of(Boolean.TRUE), Optional.of(srp));
    }

    private void sendToAll(PCCTunnel tunnel, PlspId plspId, List<Subobject> subobjects, Srp srp, Path path, Lsp lsp) {
        for (PCCSession session : this.sessions.values()) {
            boolean isDelegated = PCCTunnelManagerImpl.hasDelegation(tunnel, session);
            Tlvs tlvs = this.buildTlvs(tunnel, plspId.getValue(), Optional.of(subobjects));
            Pcrpt pcRpt = MsgBuilderUtil.createPcRtpMessage(new LspBuilder(lsp).setPlspId(plspId).setOperational(OperationalStatus.Up).setDelegate(isDelegated).setSync(true).addAugmentation(Lsp1.class, new Lsp1Builder().setCreate(tunnel.getType() == LspType.PCE_LSP).build()).setTlvs(tlvs).build(), Optional.ofNullable(srp), path);
            session.sendReport(pcRpt);
        }
    }

    private void startStateTimeout(PCCTunnel tunnel, PlspId plspId) {
        if (this.stateTimeout > -1) {
            Timeout newStateTimeout = this.timer.newTimeout(timeout -> {
                if (tunnel.getType() == LspType.PCE_LSP) {
                    this.tunnels.remove(plspId);
                    this.sendToAll(tunnel, plspId, Collections.emptyList(), MsgBuilderUtil.createSrp(Uint32.ZERO), new PathBuilder().build(), MsgBuilderUtil.createLsp(plspId.getValue(), false, Optional.empty(), false, true));
                }
            }, this.stateTimeout, TimeUnit.SECONDS);
            tunnel.setStateTimeout(newStateTimeout);
        }
    }

    private void startRedelegationTimer(PCCTunnel tunnel, PlspId plspId, PCCSession session) {
        Timeout newRedelegationTimeout = this.timer.newTimeout(timeout -> {
            this.setDelegation(plspId, null);
            int index = session.getId();
            for (int i = 1; i < this.sessions.size(); ++i) {
                PCCSession nextSession;
                if (++index == this.sessions.size()) {
                    index = 0;
                }
                if ((nextSession = this.sessions.get(index)) == null) continue;
                tunnel.cancelTimeouts();
                Tlvs tlvs = this.buildTlvs(tunnel, plspId.getValue(), Optional.empty());
                nextSession.sendReport(MsgBuilderUtil.createPcRtpMessage(MsgBuilderUtil.createLsp(plspId.getValue(), true, Optional.ofNullable(tlvs), true, false), NO_SRP, tunnel.getLspState()));
                tunnel.setDelegationHolder(nextSession.getId());
                break;
            }
        }, this.redelegationTimeout, TimeUnit.SECONDS);
        tunnel.setRedelegationTimeout(newRedelegationTimeout);
    }

    private void setDelegation(PlspId plspId, PCCSession session) {
        PCCTunnel tunnel = this.tunnels.get(plspId);
        int sessionId = session != null ? session.getId() : -1;
        tunnel.setDelegationHolder(sessionId);
    }

    private static boolean hasDelegation(PCCTunnel tunnel, PCCSession session) {
        int sessionId = session.getId();
        int delegationHolder = tunnel.getDelegationHolder();
        return delegationHolder == sessionId;
    }

    private static String getDestinationAddress(List<Subobject> subobjects, String defaultAddress) {
        if (subobjects != null && !subobjects.isEmpty()) {
            String prefix = ((IpPrefixCase)subobjects.get(subobjects.size() - 1).getSubobjectType()).getIpPrefix().getIpPrefix().getIpv4Prefix().getValue();
            return prefix.substring(0, prefix.indexOf(47));
        }
        return defaultAddress;
    }
}

