/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.pcc.mock;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.opendaylight.protocol.pcep.pcc.mock.PCCsBuilder;
import org.opendaylight.protocol.pcep.pcc.mock.protocol.PCCDispatcherImpl;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TimerHandler.class);
    private final int disconnectAfter;
    private final Timer timer = new HashedWheelTimer();
    private PCCDispatcherImpl pccDispatcher;
    private final int reconnectAfter;
    private final Optional<Uint64> syncOptDBVersion;
    private final PCCsBuilder pcCsBuilder;
    private boolean reconnectActive = false;

    public TimerHandler(PCCsBuilder pcCsBuilder, Optional<Uint64> syncOptDBVersion, int disconnectAfter, int reconnectAfter) {
        this.pcCsBuilder = pcCsBuilder;
        this.syncOptDBVersion = syncOptDBVersion;
        this.disconnectAfter = disconnectAfter;
        this.reconnectAfter = reconnectAfter;
    }

    protected void createDisconnectTask() {
        if (this.disconnectAfter > 0 && !this.reconnectActive && this.syncOptDBVersion.isPresent()) {
            this.timer.newTimeout(new DisconnectTask(), this.disconnectAfter, TimeUnit.SECONDS);
            this.reconnectActive = true;
        }
    }

    public void setPCCDispatcher(PCCDispatcherImpl dispatcher) {
        this.pccDispatcher = dispatcher;
    }

    final class ReconnectTask
    implements TimerTask {
        ReconnectTask() {
        }

        @Override
        public void run(Timeout timeout) {
            LOG.debug("Reconnecting PCCs}");
            TimerHandler.this.pcCsBuilder.createPCCs(TimerHandler.this.syncOptDBVersion.orElse(Uint64.ONE), Optional.empty());
        }
    }

    final class DisconnectTask
    implements TimerTask {
        DisconnectTask() {
        }

        @Override
        public void run(Timeout timeout) {
            LOG.debug("Disconnects PCCs, reconnect after {} seconds", (Object)TimerHandler.this.reconnectAfter);
            TimerHandler.this.pccDispatcher.close();
            if (TimerHandler.this.reconnectAfter > 0) {
                TimerHandler.this.timer.newTimeout(new ReconnectTask(), TimerHandler.this.reconnectAfter, TimeUnit.SECONDS);
            }
        }
    }
}

