/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.pcc.mock.protocol;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.opendaylight.protocol.pcep.PCEPSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PCCReconnectPromise
extends DefaultPromise<PCEPSession> {
    private static final Logger LOG = LoggerFactory.getLogger(PCCReconnectPromise.class);
    private final InetSocketAddress address;
    private final int retryTimer;
    private final int connectTimeout;
    private final Bootstrap bootstrap;
    private @GuardedBy(value={"this"}) Future<?> pending;

    PCCReconnectPromise(InetSocketAddress address, int retryTimer, int connectTimeout, Bootstrap bootstrap) {
        super(GlobalEventExecutor.INSTANCE);
        this.address = address;
        this.retryTimer = retryTimer;
        this.connectTimeout = connectTimeout;
        this.bootstrap = bootstrap;
    }

    synchronized void connect() {
        try {
            this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.connectTimeout);
            this.bootstrap.remoteAddress(this.address);
            ChannelFuture cf = this.bootstrap.connect();
            cf.addListener(new BootstrapConnectListener(this));
            this.pending = cf;
        }
        catch (Exception e) {
            LOG.info("Failed to connect to {}", (Object)this.address, (Object)e);
            this.setFailure(e);
        }
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (super.cancel(mayInterruptIfRunning)) {
            this.pending.cancel(mayInterruptIfRunning);
            return true;
        }
        return false;
    }

    @Override
    public synchronized Promise<PCEPSession> setSuccess(PCEPSession result) {
        Promise<PCEPSession> promise = super.setSuccess(result);
        LOG.debug("Promise {} completed", (Object)this);
        return promise;
    }

    synchronized boolean isInitialConnectFinished() {
        Objects.requireNonNull(this.pending);
        return this.pending.isDone() && this.pending.isSuccess();
    }

    private final class BootstrapConnectListener
    implements ChannelFutureListener {
        private final @GuardedBy(value={"this"}) Object lock;

        BootstrapConnectListener(Object lock) {
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void operationComplete(ChannelFuture cf) {
            Object object = this.lock;
            synchronized (object) {
                if (PCCReconnectPromise.this.isCancelled()) {
                    if (cf.isSuccess()) {
                        LOG.debug("Closing channels for cancelled promise {}", (Object)PCCReconnectPromise.this);
                        cf.channel().close();
                    }
                } else if (cf.isSuccess()) {
                    LOG.debug("Promise connection is successful.");
                } else {
                    LOG.debug("Attempt to connect to {} failed", (Object)PCCReconnectPromise.this.address, (Object)cf.cause());
                    if (PCCReconnectPromise.this.retryTimer == 0) {
                        LOG.debug("Retry timer value is 0. Reconnection will not be attempted");
                        PCCReconnectPromise.this.setFailure(cf.cause());
                        return;
                    }
                    EventLoop loop = cf.channel().eventLoop();
                    loop.schedule(() -> {
                        PCCReconnectPromise pCCReconnectPromise = PCCReconnectPromise.this;
                        synchronized (pCCReconnectPromise) {
                            LOG.debug("Attempting to connect to {}", (Object)PCCReconnectPromise.this.address);
                            ChannelFuture reconnectFuture = PCCReconnectPromise.this.bootstrap.connect();
                            reconnectFuture.addListener(this);
                            PCCReconnectPromise.this.pending = reconnectFuture;
                        }
                    }, (long)PCCReconnectPromise.this.retryTimer, TimeUnit.SECONDS);
                    LOG.debug("Next reconnection attempt in {}s", (Object)PCCReconnectPromise.this.retryTimer);
                }
            }
        }
    }
}

