/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.pcc.mock.protocol;

import java.net.InetSocketAddress;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.protocol.pcep.PCEPPeerProposal;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.Tlvs3;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.Tlvs3Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.lsp.db.version.tlv.LspDbVersionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.open.TlvsBuilder;
import org.opendaylight.yangtools.yang.common.Uint64;

public class PCCServerPeerProposal
implements PCEPPeerProposal {
    private boolean isAfterReconnection;
    private final Uint64 dbVersion;

    public PCCServerPeerProposal(@NonNull Uint64 dbVersion) {
        this.dbVersion = dbVersion;
    }

    @Override
    public void setPeerSpecificProposal(InetSocketAddress address, TlvsBuilder openBuilder) {
        Objects.requireNonNull(address);
        LspDbVersionBuilder lspDbVersionBuilder = new LspDbVersionBuilder();
        if (this.isAfterReconnection) {
            lspDbVersionBuilder.setLspDbVersionValue(this.dbVersion);
        } else {
            this.isAfterReconnection = true;
        }
        openBuilder.addAugmentation(Tlvs3.class, new Tlvs3Builder().setLspDbVersion(lspDbVersionBuilder.build()).build());
    }
}

