/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.pcc.mock.protocol;

import java.util.Random;
import org.opendaylight.protocol.pcep.PCEPSession;
import org.opendaylight.protocol.pcep.PCEPSessionListener;
import org.opendaylight.protocol.pcep.PCEPTerminationReason;
import org.opendaylight.protocol.pcep.pcc.mock.api.PCCSession;
import org.opendaylight.protocol.pcep.pcc.mock.api.PCCTunnelManager;
import org.opendaylight.protocol.pcep.pcc.mock.spi.MsgBuilderUtil;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated.rev181109.Pcinitiate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.Pcrpt;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.Pcupd;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.pcupd.message.pcupd.message.Updates;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.srp.object.Srp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Pcerr;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.open.Tlvs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PCCSessionListener
implements PCEPSessionListener,
PCCSession {
    private static final Logger LOG = LoggerFactory.getLogger(PCCSessionListener.class);
    private final boolean errorMode;
    private final PCCTunnelManager tunnelManager;
    private final int sessionId;
    private PCEPSession session;
    private final Random rnd = new Random();

    public PCCSessionListener(int sessionId, PCCTunnelManager tunnelManager, boolean errorMode) {
        this.errorMode = errorMode;
        this.tunnelManager = tunnelManager;
        this.sessionId = sessionId;
    }

    @Override
    public void onMessage(PCEPSession psession, Message message) {
        LOG.trace("Received message: {}", (Object)message);
        if (this.errorMode) {
            psession.sendMessage(this.createErrorMessage(message));
            return;
        }
        if (message instanceof Pcupd) {
            Updates upd = ((Pcupd)message).getPcupdMessage().getUpdates().get(0);
            this.tunnelManager.onMessagePcupd(upd, this);
        } else if (message instanceof Pcinitiate) {
            this.tunnelManager.onMessagePcInitiate(((Pcinitiate)message).getPcinitiateMessage().getRequests().get(0), this);
        }
    }

    @Override
    public void onSessionUp(PCEPSession psession) {
        LOG.debug("Session up.");
        this.session = psession;
        this.tunnelManager.onSessionUp(this);
    }

    @Override
    public void onSessionDown(PCEPSession psession, Exception exception) {
        LOG.info("Session down with cause : {} or exception: {}", exception.getCause(), exception, exception);
        this.tunnelManager.onSessionDown(this);
        try {
            psession.close();
        }
        catch (Exception ie) {
            LOG.warn("Error closing session", ie);
        }
    }

    @Override
    public void onSessionTerminated(PCEPSession psession, PCEPTerminationReason cause) {
        LOG.info("Session terminated. Cause : {}", (Object)cause.toString());
    }

    @Override
    public void sendReport(Pcrpt reportMessage) {
        this.session.sendMessage(reportMessage);
    }

    @Override
    public void sendError(Pcerr errorMessage) {
        this.session.sendMessage(errorMessage);
    }

    @Override
    public int getId() {
        return this.sessionId;
    }

    @Override
    public Tlvs getRemoteTlvs() {
        return this.session.getRemoteTlvs();
    }

    @Override
    public Tlvs localSessionCharacteristics() {
        return this.session.getLocalTlvs();
    }

    private PCEPErrors getRandomError() {
        return PCEPErrors.values()[this.rnd.nextInt(PCEPErrors.values().length)];
    }

    private Pcerr createErrorMessage(Message message) {
        Srp srp = message instanceof Pcupd ? ((Pcupd)message).getPcupdMessage().getUpdates().get(0).getSrp() : ((Pcinitiate)message).getPcinitiateMessage().getRequests().get(0).getSrp();
        return MsgBuilderUtil.createErrorMsg(this.getRandomError(), srp.getOperationId().getValue());
    }
}

