/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi;

import java.io.Serializable;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Uint8;

final class PCEPErrorIdentifier
implements Serializable {
    private static final long serialVersionUID = 2434590156751699872L;
    private final @NonNull Uint8 type;
    private final @NonNull Uint8 value;

    PCEPErrorIdentifier(Uint8 type, Uint8 value) {
        this.type = Objects.requireNonNull(type);
        this.value = Objects.requireNonNull(value);
    }

    @NonNull Uint8 getType() {
        return this.type;
    }

    @NonNull Uint8 getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PCEPErrorIdentifier)) {
            return false;
        }
        PCEPErrorIdentifier other = (PCEPErrorIdentifier)obj;
        return this.type.equals(other.type) && this.value.equals(other.value);
    }

    public String toString() {
        return "type " + this.type + " value " + this.value;
    }
}

