/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi.pojo;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.concepts.HandlerRegistry;
import org.opendaylight.protocol.pcep.spi.EROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.EROSubobjectRegistry;
import org.opendaylight.protocol.pcep.spi.EROSubobjectSerializer;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.SubobjectType;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public final class SimpleEROSubobjectRegistry
implements EROSubobjectRegistry {
    private final HandlerRegistry<DataContainer, EROSubobjectParser, EROSubobjectSerializer> handlers = new HandlerRegistry();

    public Registration registerSubobjectParser(int subobjectType, EROSubobjectParser parser) {
        Preconditions.checkArgument(subobjectType >= 0 && subobjectType <= 65535);
        return this.handlers.registerParser(subobjectType, parser);
    }

    public Registration registerSubobjectSerializer(Class<? extends SubobjectType> subobjectClass, EROSubobjectSerializer serializer) {
        return this.handlers.registerSerializer(subobjectClass, serializer);
    }

    @Override
    public Subobject parseSubobject(int type, ByteBuf buffer, boolean loose) throws PCEPDeserializerException {
        Preconditions.checkArgument(type >= 0 && type <= 65535);
        EROSubobjectParser parser = this.handlers.getParser(type);
        if (parser == null) {
            return null;
        }
        return parser.parseSubobject(buffer, loose);
    }

    @Override
    public void serializeSubobject(Subobject subobject, ByteBuf buffer) {
        EROSubobjectSerializer serializer = this.handlers.getSerializer(subobject.getSubobjectType().implementedInterface());
        if (serializer == null) {
            return;
        }
        serializer.serializeSubobject(subobject, buffer);
    }
}

