/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi.pojo;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.concepts.HandlerRegistry;
import org.opendaylight.protocol.pcep.spi.LabelParser;
import org.opendaylight.protocol.pcep.spi.LabelRegistry;
import org.opendaylight.protocol.pcep.spi.LabelSerializer;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.LabelType;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class SimpleLabelRegistry
implements LabelRegistry {
    private final HandlerRegistry<DataContainer, LabelParser, LabelSerializer> handlers = new HandlerRegistry();

    public Registration registerLabelParser(int ctype, LabelParser parser) {
        Preconditions.checkArgument(ctype >= 0 && ctype <= 255);
        return this.handlers.registerParser(ctype, parser);
    }

    public Registration registerLabelSerializer(Class<? extends LabelType> labelClass, LabelSerializer serializer) {
        return this.handlers.registerSerializer(labelClass, serializer);
    }

    @Override
    public LabelType parseLabel(int ctype, ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument(ctype >= 0 && ctype <= 255);
        LabelParser parser = this.handlers.getParser(ctype);
        if (parser == null) {
            return null;
        }
        return parser.parseLabel(buffer);
    }

    @Override
    public void serializeLabel(boolean unidirectional, boolean global, LabelType label, ByteBuf buffer) {
        LabelSerializer serializer = this.handlers.getSerializer(label.implementedInterface());
        if (serializer != null) {
            serializer.serializeLabel(unidirectional, global, label, buffer);
        }
    }
}

