/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi.pojo;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.concepts.HandlerRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public final class SimpleTlvRegistry
implements TlvRegistry {
    private final HandlerRegistry<DataContainer, TlvParser, TlvSerializer> handlers = new HandlerRegistry();

    public Registration registerTlvParser(int tlvType, TlvParser parser) {
        Preconditions.checkArgument(tlvType >= 0 && tlvType < 65535);
        return this.handlers.registerParser(tlvType, parser);
    }

    public Registration registerTlvSerializer(Class<? extends Tlv> tlvClass, TlvSerializer serializer) {
        return this.handlers.registerSerializer(tlvClass, serializer);
    }

    @Override
    public Tlv parseTlv(int type, ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument(type >= 0 && type <= 65535);
        TlvParser parser = this.handlers.getParser(type);
        if (parser == null) {
            return null;
        }
        return parser.parseTlv(buffer);
    }

    @Override
    public void serializeTlv(Tlv tlv, ByteBuf buffer) {
        TlvSerializer serializer = this.handlers.getSerializer(tlv.implementedInterface());
        if (serializer == null) {
            return;
        }
        serializer.serializeTlv(tlv, buffer);
    }
}

