/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.sync.optimizations;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.speaker.entity.id.tlv.SpeakerEntityId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.speaker.entity.id.tlv.SpeakerEntityIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;

public class SpeakerEntityIdTlvParser
implements TlvParser,
TlvSerializer {
    public static final int TYPE = 24;

    @Override
    public void serializeTlv(Tlv tlv, ByteBuf buffer) {
        Preconditions.checkArgument(tlv instanceof SpeakerEntityId, "Tlv object is not instance of SpeakerEntityId.");
        ByteBuf body = Unpooled.buffer();
        body.writeBytes(((SpeakerEntityId)tlv).getSpeakerEntityIdValue());
        TlvUtil.formatTlv(24, body, buffer);
    }

    @Override
    public Tlv parseTlv(ByteBuf buffer) throws PCEPDeserializerException {
        if (buffer == null) {
            return null;
        }
        return new SpeakerEntityIdBuilder().setSpeakerEntityIdValue(ByteArray.readAllBytes(buffer)).build();
    }
}

