/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.util;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ByteArray {
    private static final Logger LOG = LoggerFactory.getLogger(ByteArray.class);

    private ByteArray() {
    }

    public static byte[] readBytes(ByteBuf buffer, int length) {
        Preconditions.checkArgument(buffer != null && buffer.readableBytes() >= length, "Buffer cannot be read for %s bytes.", length);
        byte[] result = new byte[length];
        buffer.readBytes(result);
        return result;
    }

    public static byte[] readAllBytes(ByteBuf buffer) {
        return ByteArray.readBytes(buffer, buffer.readableBytes());
    }

    public static byte[] getBytes(ByteBuf buffer, int length) {
        Preconditions.checkArgument(buffer != null && buffer.readableBytes() >= length, "Buffer cannot be read for %s bytes.", length);
        byte[] result = new byte[length];
        buffer.getBytes(buffer.readerIndex(), result);
        return result;
    }

    public static byte[] getAllBytes(ByteBuf buffer) {
        return ByteArray.getBytes(buffer, buffer.readableBytes());
    }

    public static byte[] subByte(byte[] bytes, int startIndex, int length) {
        Preconditions.checkArgument(ByteArray.checkLength(bytes, length) && ByteArray.checkStartIndex(bytes, startIndex, length), "Cannot create subByte, invalid arguments: Length: %s startIndex: %s", length, startIndex);
        byte[] res = new byte[length];
        System.arraycopy(bytes, startIndex, res, 0, length);
        return res;
    }

    private static boolean checkLength(byte[] bytes, int length) {
        return length > 0 && bytes.length > 0 && length <= bytes.length;
    }

    private static boolean checkStartIndex(byte[] bytes, int startIndex, int length) {
        return startIndex >= 0 && startIndex < bytes.length && startIndex + length <= bytes.length;
    }

    public static int bytesToInt(byte[] bytes) {
        byte[] res;
        Preconditions.checkArgument(bytes.length <= 4, "Cannot convert bytes to integer. Byte array too big.");
        if (bytes.length != 4) {
            res = new byte[4];
            System.arraycopy(bytes, 0, res, 4 - bytes.length, bytes.length);
        } else {
            res = bytes;
        }
        return ByteBuffer.wrap(res).getInt();
    }

    public static long bytesToLong(byte[] bytes) {
        byte[] res;
        Preconditions.checkArgument(bytes.length <= 8, "Cannot convert bytes to long.Byte array too big.");
        if (bytes.length != 8) {
            res = new byte[8];
            System.arraycopy(bytes, 0, res, 8 - bytes.length, bytes.length);
        } else {
            res = bytes;
        }
        return ByteBuffer.wrap(res).getLong();
    }

    public static byte[] cutBytes(byte[] bytes, int count) {
        Preconditions.checkArgument(bytes.length != 0 && count <= bytes.length && count > 0, "Cannot cut bytes, invalid arguments: Count: %s bytes.length: %s", count, bytes.length);
        return Arrays.copyOfRange(bytes, count, bytes.length);
    }

    public static byte[] fileToBytes(String name) throws IOException {
        File file = new File(name);
        int offset = 0;
        if (file.length() > Integer.MAX_VALUE) {
            throw new IOException("Too large file to load in byte array.");
        }
        byte[] byteArray = new byte[(int)file.length()];
        try (FileInputStream fin = new FileInputStream(file);){
            while (offset < byteArray.length) {
                int numRead = fin.read(byteArray, offset, byteArray.length - offset);
                if (numRead < 0) continue;
                offset += numRead;
            }
            fin.close();
        }
        return byteArray;
    }

    public static byte copyBitsRange(byte src, int fromBit, int length) {
        Preconditions.checkArgument(fromBit >= 0 && fromBit <= 7 && length >= 1 && length <= 8, "fromBit or toBit is out of range.");
        Preconditions.checkArgument(fromBit + length <= 8, "Out of range.");
        byte retByte = 0;
        int retI = 0;
        for (int i = fromBit + length - 1; i >= fromBit; --i) {
            if ((src & 1 << 8 - i - 1) != 0) {
                retByte = (byte)(retByte | 1 << retI);
            }
            ++retI;
        }
        return retByte;
    }

    public static String bytesToHRString(byte[] bytes) {
        try {
            return StandardCharsets.UTF_8.newDecoder().decode(ByteBuffer.wrap(bytes)).toString();
        }
        catch (CharacterCodingException e) {
            LOG.debug("Could not apply UTF-8 encoding.", e);
            return Arrays.toString(bytes);
        }
    }

    public static String encodeBase64(ByteBuf buffer) {
        return Base64.getEncoder().encodeToString(ByteArray.readAllBytes(buffer));
    }
}

